/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import jenkins.plugins.logstash.LogstashWriter;
import jenkins.plugins.logstash.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogstashSendStep
extends Step {
    private int maxLines;
    private boolean failBuild;

    @DataBoundConstructor
    public LogstashSendStep(int maxLines, boolean failBuild) {
        this.maxLines = maxLines;
        this.failBuild = failBuild;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.maxLines, this.failBuild);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient int maxLines;
        private final transient boolean failBuild;

        Execution(StepContext context, int maxLines, boolean failBuild) {
            super(context);
            this.maxLines = maxLines;
            this.failBuild = failBuild;
        }

        protected Void run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            PrintStream errorStream = listener.getLogger();
            LogstashWriter logstash = new LogstashWriter(run, errorStream, listener, run.getCharset());
            logstash.writeBuildLog(this.maxLines);
            if (this.failBuild && logstash.isConnectionBroken()) {
                throw new Exception("Failed to send data to Indexer");
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getFunctionName() {
            return "logstashSend";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet<Class> contexts = new HashSet<Class>();
            contexts.add(TaskListener.class);
            contexts.add(Run.class);
            return contexts;
        }
    }
}

