/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import jenkins.plugins.logstash.persistence.HostBasedLogstashIndexerDao;
import org.apache.commons.lang.StringUtils;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class RabbitMqDao
extends HostBasedLogstashIndexerDao {
    private transient ConnectionFactory pool;
    private final String queue;
    private final String username;
    private final String password;
    private final String charset;
    private final String virtualHost;

    public RabbitMqDao(String host, int port, String key, String username, String password, Charset charset, String virtualHost) {
        this(null, host, port, key, username, password, charset, virtualHost);
    }

    RabbitMqDao(ConnectionFactory factory, String host, int port, String queue, String username, String password, Charset charset, String vhost) {
        super(host, port);
        this.queue = queue;
        this.username = username;
        this.password = password;
        this.charset = charset.toString();
        this.virtualHost = vhost;
        if (StringUtils.isBlank((String)queue)) {
            throw new IllegalArgumentException("rabbit queue name is required");
        }
        this.pool = factory;
        this.initPool();
    }

    private synchronized ConnectionFactory getPool() {
        if (this.pool == null) {
            this.pool = new ConnectionFactory();
            this.initPool();
        }
        return this.pool;
    }

    private void initPool() {
        if (this.pool != null) {
            this.pool.setHost(this.getHost());
            this.pool.setPort(this.getPort());
            if (this.virtualHost != null) {
                this.pool.setVirtualHost(this.virtualHost);
            }
            if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
                this.pool.setPassword(this.password);
                this.pool.setUsername(this.username);
            }
        }
    }

    public String getQueue() {
        return this.queue;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(String data) throws IOException {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.getPool().newConnection();
            channel = connection.createChannel();
            try {
                channel.queueDeclarePassive(this.queue);
            }
            catch (IOException e) {
                this.finalizeChannel(channel);
                channel = connection.createChannel();
                channel.queueDeclare(this.queue, true, false, false, null);
            }
            channel.basicPublish("", this.queue, null, data.getBytes(this.charset));
            this.finalizeChannel(channel);
            this.finalizeConnection(connection);
        }
        catch (Throwable throwable) {
            this.finalizeChannel(channel);
            this.finalizeConnection(connection);
            throw throwable;
        }
    }

    private void finalizeConnection(Connection connection) {
        if (connection != null && connection.isOpen()) {
            try {
                connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void finalizeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

