/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import jenkins.plugins.logstash.persistence.AbstractLogstashIndexerDao;
import jenkins.plugins.logstash.utils.SSLHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ElasticSearchDao
extends AbstractLogstashIndexerDao {
    private transient HttpClientBuilder clientBuilder;
    private final URI uri;
    private final String auth;
    private String username;
    private String password;
    private String mimeType;
    private byte[] keystoreBytes;
    private String keyStorePassword;

    public ElasticSearchDao(URI uri, String username, String password) {
        this(null, uri, username, password);
    }

    ElasticSearchDao(HttpClientBuilder factory, URI uri, String username, String password) {
        if (uri == null) {
            throw new IllegalArgumentException("uri field must not be empty");
        }
        this.uri = uri;
        this.username = username;
        this.password = password;
        try {
            uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.auth = StringUtils.isNotBlank((String)username) ? Base64.encodeBase64String((byte[])(username + ":" + StringUtils.defaultString((String)password)).getBytes(StandardCharsets.UTF_8)) : null;
        this.clientBuilder = factory;
    }

    private byte[] getKeystoreBytes() {
        return this.keystoreBytes;
    }

    private String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    private synchronized HttpClientBuilder getClientBuilder() throws IOException {
        if (this.clientBuilder == null) {
            this.clientBuilder = HttpClientBuilder.create();
            if (this.getKeystoreBytes() != null) {
                try {
                    KeyStore trustStore = KeyStore.getInstance("PKCS12");
                    String pwd = this.getKeyStorePassword();
                    if (pwd == null) {
                        pwd = "";
                    }
                    trustStore.load(new ByteArrayInputStream(this.getKeystoreBytes()), pwd.toCharArray());
                    SSLHelper.setClientBuilderSSLContext(this.clientBuilder, trustStore);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new IOException(e);
                }
            }
        }
        return this.clientBuilder;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKey() {
        return this.uri.getPath();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    String getAuth() {
        return this.auth;
    }

    public void setCustomKeyStore(KeyStore customKeyStore, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (customKeyStore != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            customKeyStore.store(bos, keyStorePassword.toCharArray());
            this.keystoreBytes = bos.toByteArray();
            this.keyStorePassword = keyStorePassword;
        }
    }

    HttpPost getHttpPost(String data) {
        HttpPost postRequest = new HttpPost(this.uri);
        String mimeType = this.getMimeType();
        StringEntity input = new StringEntity(data, StandardCharsets.UTF_8);
        mimeType = mimeType != null ? mimeType : ContentType.APPLICATION_JSON.toString();
        input.setContentType(mimeType);
        postRequest.setEntity((HttpEntity)input);
        if (this.auth != null) {
            postRequest.addHeader("Authorization", "Basic " + this.auth);
        }
        return postRequest;
    }

    @Override
    public void push(String data) throws IOException {
        HttpPost post = this.getHttpPost(data);
        try (CloseableHttpClient httpClient = this.getClientBuilder().build();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new IOException(this.getErrorMessage(response));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMessage(CloseableHttpResponse response) {
        ByteArrayOutputStream byteStream = null;
        try (PrintStream stream = null;){
            byteStream = new ByteArrayOutputStream();
            stream = new PrintStream((OutputStream)byteStream, true, StandardCharsets.UTF_8.name());
            try {
                stream.print("HTTP error code: ");
                stream.println(response.getStatusLine().getStatusCode());
                stream.print("URI: ");
                stream.println(this.uri.toString());
                stream.println("RESPONSE: " + response.toString());
                response.getEntity().writeTo((OutputStream)stream);
            }
            catch (IOException e) {
                stream.println(ExceptionUtils.getStackTrace((Throwable)e));
            }
            stream.flush();
            String e = byteStream.toString(StandardCharsets.UTF_8.name());
            return e;
        }
    }

    @Override
    public String getDescription() {
        return this.uri.toString();
    }
}

