/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.logstash.LogstashConfiguration;
import jenkins.plugins.logstash.LogstashWriter;
import jenkins.plugins.logstash.Messages;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LogstashNotifier
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(LogstashNotifier.class.getName());
    private final int maxLines;
    private final boolean failBuild;

    @DataBoundConstructor
    public LogstashNotifier(int maxLines, boolean failBuild) {
        this.maxLines = maxLines;
        this.failBuild = failBuild;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.perform((Run<?, ?>)build, (TaskListener)listener);
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (!this.perform(run, listener)) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean perform(Run<?, ?> run, TaskListener listener) {
        LogstashConfiguration configuration = LogstashConfiguration.getInstance();
        if (!configuration.isEnabled()) {
            LOGGER.log(Level.FINE, "Logstash is disabled. Logs will not be forwarded.");
            return true;
        }
        PrintStream errorPrintStream = listener.getLogger();
        LogstashWriter logstash = this.getLogStashWriter(run, errorPrintStream, listener);
        logstash.writeBuildLog(this.maxLines);
        return !this.failBuild || !logstash.isConnectionBroken();
    }

    LogstashWriter getLogStashWriter(Run<?, ?> run, OutputStream errorStream, TaskListener listener) {
        return new LogstashWriter(run, errorStream, listener, run.getCharset());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public FormValidation doCheckMaxLines(@QueryParameter(value="value") String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.ValueIsInt());
            }
            return FormValidation.ok();
        }
    }
}

