/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

public final class ReadWriteTextFile {
    private static final Logger LOGGER = Logger.getLogger(ReadWriteTextFile.class.getName());

    private ReadWriteTextFile() {
    }

    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try (BufferedReader input = new BufferedReader(new FileReader(aFile));){
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line).append("\n");
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Failure reading from " + aFile.getPath());
        }
        return contents.toString();
    }

    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            boolean created = aFile.createNewFile();
            if (created) {
                LOGGER.fine(aFile.getPath() + " created");
            } else {
                LOGGER.fine(aFile.getPath() + " already exists");
            }
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + String.valueOf(aFile));
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + String.valueOf(aFile));
        }
        try (BufferedWriter output = new BufferedWriter(new FileWriter(aFile));){
            output.write(aContents);
        }
    }
}

