/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.ClassicParsingStrategy;
import hudson.plugins.logparser.ParsingStrategy;
import hudson.plugins.logparser.StreamParsingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

class ParsingStrategyLocator {
    private static final String SYSTEM_PROPERTY = ParsingStrategy.class.getName();
    private static final String CLASSIC = ClassicParsingStrategy.class.getName();
    private static final String STREAM = StreamParsingStrategy.class.getName();
    private static final Logger LOGGER = Logger.getLogger(ParsingStrategyLocator.class.getName());
    private final Map<String, String> systemProperties;

    ParsingStrategyLocator(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    static ParsingStrategyLocator create() {
        HashMap<String, String> typedProperties = new HashMap<String, String>();
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            typedProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new ParsingStrategyLocator(typedProperties);
    }

    ParsingStrategy get() {
        String strategy = this.systemProperties.get(SYSTEM_PROPERTY);
        if (STREAM.equals(strategy)) {
            LOGGER.info("Using " + STREAM + " as requested by system property " + SYSTEM_PROPERTY);
            return new StreamParsingStrategy();
        }
        if (strategy == null) {
            LOGGER.info("Defaulting to " + CLASSIC);
        } else if (CLASSIC.equals(strategy)) {
            LOGGER.info("Using " + CLASSIC + " as requested by system property " + SYSTEM_PROPERTY);
        } else {
            LOGGER.warning("Defaulting to " + CLASSIC + " because system property " + SYSTEM_PROPERTY + " was set to invalid strategy " + strategy);
        }
        return new ClassicParsingStrategy();
    }
}

