/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.LineToStatus;
import hudson.plugins.logparser.ParsingInput;
import hudson.plugins.logparser.ParsingRulePattern;
import hudson.plugins.logparser.ParsingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StreamParsingStrategy
implements ParsingStrategy {
    StreamParsingStrategy() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap<String, String> parse(ParsingInput input) {
        String[] parsingRulesArray = input.getParsingRulesArray();
        Pattern[] compiledPatterns = input.getCompiledPatterns();
        LinkedList<ParsingRulePattern> parsingRulePatterns = new LinkedList<ParsingRulePattern>();
        for (int i = 0; i < parsingRulesArray.length; ++i) {
            String rule = parsingRulesArray[i];
            Pattern pattern = compiledPatterns[i];
            parsingRulePatterns.add(new ParsingRulePattern(rule, pattern));
        }
        LineToStatus toStatus = new LineToStatus(parsingRulePatterns);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input.getLog(), input.getCharset()));){
            HashMap<String, String> hashMap;
            block15: {
                Stream<String> lines = reader.lines();
                try {
                    List statusByLine = lines.map(toStatus).collect(Collectors.toList());
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (int i = 0; i < statusByLine.size(); ++i) {
                        String status = (String)statusByLine.get(i);
                        if ("NONE".equals(status)) continue;
                        result.put(Integer.toString(i), status);
                    }
                    hashMap = result;
                    if (lines == null) break block15;
                }
                catch (Throwable throwable) {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lines.close();
            }
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

