/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.FilePath;
import hudson.plugins.logparser.LogParserLogPart;
import hudson.plugins.logparser.LogParserReader;
import hudson.plugins.logparser.LogParserThread;
import hudson.plugins.logparser.LogParserUtils;
import hudson.plugins.logparser.ParsingInput;
import hudson.plugins.logparser.ParsingStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class ClassicParsingStrategy
implements ParsingStrategy {
    ClassicParsingStrategy() {
    }

    @Override
    public HashMap<String, String> parse(ParsingInput input) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String tempFileLocation = (String)tempDir + "log-parser_" + input.getSignature();
        File tempFile = new File(tempFileLocation);
        FilePath tempFilePath = new FilePath(tempFile);
        try {
            HashMap<String, String> hashMap;
            tempFilePath.copyFrom(input.getLog());
            logger.log(Level.INFO, "Local temp file:" + tempFileLocation);
            BufferedReader reader = new BufferedReader(new InputStreamReader(tempFilePath.read(), input.getCharset()));
            try {
                String[] parsingRulesArray = input.getParsingRulesArray();
                Pattern[] compiledPatterns = input.getCompiledPatterns();
                int threadCounter = 0;
                ArrayList<LogParserThread> runners = new ArrayList<LogParserThread>();
                LogParserReader logParserReader = new LogParserReader(reader);
                ExecutorService execSvc = Executors.newCachedThreadPool();
                int linesInLog = LogParserUtils.countLines(tempFileLocation);
                int threadsNeeded = linesInLog / LogParserUtils.getLinesPerThread() + 1;
                for (int i = 0; i < threadsNeeded; ++i) {
                    LogParserThread logParserThread = new LogParserThread(logParserReader, parsingRulesArray, compiledPatterns, threadCounter);
                    runners.add(logParserThread);
                    execSvc.execute(logParserThread);
                    ++threadCounter;
                }
                execSvc.shutdown();
                execSvc.awaitTermination(3600L, TimeUnit.SECONDS);
                int runnersSize = runners.size();
                LogParserThread[] sortedRunners = new LogParserThread[runnersSize];
                for (LogParserThread logParserThread : runners) {
                    LogParserLogPart logPart = logParserThread.getLogPart();
                    if (logPart == null) continue;
                    int logPartNum = logPart.getLogPartNum();
                    sortedRunners[logPartNum] = logParserThread;
                }
                HashMap<String, String> result = new HashMap<String, String>();
                for (int i = 0; i < runnersSize; ++i) {
                    LogParserThread logParserThread = sortedRunners[i];
                    if (logParserThread == null) continue;
                    HashMap<String, String> moreLineStatusMatches = this.getLineStatusMatches(logParserThread.getLineStatuses(), i);
                    result.putAll(moreLineStatusMatches);
                }
                hashMap = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return hashMap;
        }
        finally {
            try {
                tempFilePath.delete();
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.WARNING, "Failed to delete " + String.valueOf(tempFilePath), e);
            }
        }
    }

    private HashMap<String, String> getLineStatusMatches(String[] statuses, int logPart) {
        HashMap<String, String> result = new HashMap<String, String>();
        int linesPerThread = LogParserUtils.getLinesPerThread();
        if (statuses != null && statuses.length > 0) {
            for (int i = 0; i < statuses.length; ++i) {
                String status = statuses[i];
                int line_num = i + logPart * linesPerThread;
                result.put(String.valueOf(line_num), status);
            }
        }
        return result;
    }
}

