/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jenkins.security.plugins.ldap.LdapEntryMapper;
import jenkins.util.SetContextClassLoader;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.authentication.AuthenticationServiceException;

@Restricted(value={NoExternalUse.class})
public class LDAPExtendedTemplate
extends LdapTemplate {
    public LDAPExtendedTemplate(ContextSource dirContextFactory) {
        super(dirContextFactory);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public <T> T searchForFirstEntry(@NonNull String base, @NonNull String filter, Object[] filterArgs, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        try (SetContextClassLoader sccl = new SetContextClassLoader(LDAPExtendedTemplate.class);){
            T t;
            block13: {
                SearchResultEnumeration<T> searchEnum = this.searchForAllEntriesEnum(base, filter, filterArgs, attributeNames, mapper);
                try {
                    T t2 = t = searchEnum.hasMore() ? (T)searchEnum.next() : null;
                    if (searchEnum == null) break block13;
                }
                catch (Throwable throwable) {
                    if (searchEnum != null) {
                        try {
                            searchEnum.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                searchEnum.close();
            }
            return t;
        }
        catch (NamingException e) {
            throw new AuthenticationServiceException("Unable to get first element", (Throwable)e);
        }
    }

    @NonNull
    public <T> List<? extends T> searchForAllEntries(@NonNull String base, @NonNull String filter, Object[] filterArgs, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        ArrayList<T> results = new ArrayList<T>();
        try (SetContextClassLoader sccl = new SetContextClassLoader(LDAPExtendedTemplate.class);
             SearchResultEnumeration<T> searchEnum = this.searchForAllEntriesEnum(base, filter, filterArgs, attributeNames, mapper);){
            while (searchEnum.hasMore()) {
                results.add(searchEnum.next());
            }
        }
        catch (NamingException e) {
            throw new AuthenticationServiceException("Error processing search results", (Throwable)e);
        }
        return results;
    }

    @NonNull
    private <T> SearchResultEnumeration<T> searchForAllEntriesEnum(@NonNull String base, @NonNull String filter, Object[] params, String[] attributeNames, @NonNull LdapEntryMapper<T> mapper) {
        return (SearchResultEnumeration)this.executeReadOnly(ctx -> {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(attributeNames);
            NamingEnumeration<SearchResult> searchResults = ctx.search(base, filter, params, controls);
            return new SearchResultEnumeration(searchResults, mapper, this.getDnSuffix(base, ctx.getNameInNamespace()));
        });
    }

    private String getDnSuffix(String base, String nameInNamespace) {
        StringBuilder suffix = new StringBuilder();
        if (base != null && !base.isEmpty()) {
            suffix.append(",").append(base);
        }
        if (nameInNamespace != null && !nameInNamespace.isEmpty()) {
            suffix.append(",").append(nameInNamespace);
        }
        return suffix.toString();
    }

    private static final class SearchResultEnumeration<T>
    implements AutoCloseable,
    NamingEnumeration<T> {
        private final NamingEnumeration<SearchResult> searchResults;
        private final LdapEntryMapper<T> mapper;
        private final String dnSuffix;

        SearchResultEnumeration(NamingEnumeration<SearchResult> searchResults, LdapEntryMapper<T> mapper, String dnSuffix) {
            this.searchResults = searchResults;
            this.mapper = mapper;
            this.dnSuffix = dnSuffix;
        }

        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.searchResults.hasMore();
        }

        @Override
        public T next() throws NamingException {
            SearchResult searchResult = this.searchResults.next();
            return this.mapper.mapAttributes(searchResult.getName() + this.dnSuffix, searchResult.getAttributes());
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                throw new AuthenticationServiceException("Unable to check for more elements", (Throwable)e);
            }
        }

        @Override
        public T nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new AuthenticationServiceException("Unable to get next element", (Throwable)e);
            }
        }
    }
}

