/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.junitattachments.AttachmentPublisher;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public class GetTestDataMethodObject {
    private static final Logger LOG = Logger.getLogger(GetTestDataMethodObject.class.getName());
    private final Run<?, ?> build;
    private final TestResult testResult;
    private final Map<String, Map<String, List<String>>> attachments = new HashMap<String, Map<String, List<String>>>();
    private final FilePath attachmentsStorage;
    private final TaskListener listener;
    private final FilePath workspace;
    private static final String PREFIX = "[[ATTACHMENT|";
    private static final String SUFFIX = "]]";
    private static final Pattern ATTACHMENT_PATTERN = Pattern.compile("\\[\\[ATTACHMENT\\|.+\\]\\]");

    @Deprecated
    public GetTestDataMethodObject(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, TestResult testResult) {
        this.build = build;
        this.testResult = testResult;
        this.listener = listener;
        this.attachmentsStorage = AttachmentPublisher.getAttachmentPath(build);
        this.workspace = build.getWorkspace();
    }

    public GetTestDataMethodObject(Run<?, ?> build, @NonNull FilePath workspace, Launcher launcher, TaskListener listener, TestResult testResult) {
        this.build = build;
        this.testResult = testResult;
        this.listener = listener;
        this.attachmentsStorage = AttachmentPublisher.getAttachmentPath(build);
        this.workspace = workspace;
    }

    public Map<String, Map<String, List<String>>> getAttachments() throws IllegalStateException, IOException, InterruptedException {
        Map<String, String> reports = this.getReports();
        LOG.fine("reports: " + String.valueOf(reports));
        for (Map.Entry<String, String> report : reports.entrySet()) {
            String className = report.getKey();
            FilePath reportFile = this.workspace.child(report.getValue());
            FilePath target = AttachmentPublisher.getAttachmentPath(this.attachmentsStorage, className, null);
            this.attachFilesForReport(className, reportFile, target);
            this.attachStdInAndOut(className, reportFile);
        }
        return this.attachments;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
    private void attachFilesForReport(String className, FilePath reportFile, FilePath target) throws IOException, InterruptedException {
        FilePath testDir = reportFile.getParent().child(className);
        if (testDir.exists()) {
            target.mkdirs();
            if (testDir.copyRecursiveTo(target) > 0) {
                DirectoryScanner d = new DirectoryScanner();
                d.setBasedir(target.getRemote());
                d.scan();
                Map tests = this.attachments.getOrDefault(className, new HashMap());
                tests.put("", new ArrayList<String>(Arrays.asList(d.getIncludedFiles())));
                this.attachments.put(className, tests);
            }
        }
    }

    private Map<String, String> getReports() throws IOException, InterruptedException {
        HashMap<String, String> reports = new HashMap<String, String>();
        for (SuiteResult suiteResult : this.testResult.getSuites()) {
            String f = suiteResult.getFile();
            if (f != null) {
                for (String className : suiteResult.getClassNames()) {
                    reports.put(className, f);
                }
            }
            String suiteStdout = Util.fixNull((String)suiteResult.getStdout());
            String suiteStderr = Util.fixNull((String)suiteResult.getStderr());
            for (CaseResult cr : suiteResult.getCases()) {
                String stdout = Util.fixNull((String)cr.getStdout());
                String caseStdout = suiteStdout.equals(stdout) ? null : stdout;
                String stderr = Util.fixNull((String)cr.getStderr());
                String caseStderr = suiteStderr.equals(stderr) ? null : stderr;
                this.findAttachmentsInOutput(cr.getClassName(), cr.getName(), caseStdout + "\n" + caseStderr);
            }
            this.findAttachmentsInOutput(suiteResult.getName(), null, suiteStdout);
            this.findAttachmentsInOutput(suiteResult.getName(), null, suiteStderr);
        }
        return reports;
    }

    private void findAttachmentsInOutput(String className, String testName, String output) throws IOException, InterruptedException {
        if (Util.fixEmpty((String)output) == null) {
            return;
        }
        Matcher matcher = ATTACHMENT_PATTERN.matcher(output);
        while (matcher.find()) {
            String fileName;
            String line = matcher.group().trim();
            int idx = (line = line.substring(PREFIX.length(), line.length() - SUFFIX.length())).indexOf(124);
            if (idx >= 0) {
                line = line.substring(0, idx);
            }
            if ((fileName = line) == null) continue;
            FilePath src = this.workspace.child(fileName);
            if (src.isDirectory()) {
                this.listener.getLogger().println("Attachment " + fileName + " was referenced from the test '" + className + "' but it is a directory, not a file. Skipping.");
                continue;
            }
            if (src.exists()) {
                this.captureAttachment(className, testName, src);
                continue;
            }
            this.listener.getLogger().println("Attachment " + fileName + " was referenced from the test '" + className + "' but it doesn't exist. Skipping.");
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
    private void attachStdInAndOut(String className, FilePath reportFile) throws IOException, InterruptedException {
        FilePath stdInAndOut = reportFile.getParent().child(className + "-output.txt");
        LOG.fine("stdInAndOut: " + String.valueOf(stdInAndOut.absolutize()));
        if (stdInAndOut.exists()) {
            this.captureAttachment(className, stdInAndOut);
        }
    }

    private void captureAttachment(String className, FilePath src) throws IOException, InterruptedException {
        this.captureAttachment(className, null, src);
    }

    private void captureAttachment(String className, String testName, FilePath src) throws IOException, InterruptedException {
        String filename;
        List<String> testFiles;
        Map<String, List<String>> tests = this.attachments.get(className);
        if (tests == null) {
            tests = new HashMap<String, List<String>>();
            this.attachments.put(className, tests);
        }
        if ((testFiles = tests.get(Util.fixNull((String)testName))) == null) {
            testFiles = new ArrayList<String>();
            tests.put(Util.fixNull((String)testName), testFiles);
        }
        if (!testFiles.contains(filename = src.getName())) {
            FilePath target = AttachmentPublisher.getAttachmentPath(this.attachmentsStorage, className, testName);
            target.mkdirs();
            FilePath dst = new FilePath(target, filename);
            src.copyTo(dst);
            testFiles.add(filename);
        }
    }

    private static boolean containsFilename(Map<String, List<String>> map, String filename) {
        for (List<String> list : map.values()) {
            if (!list.contains(filename)) continue;
            return true;
        }
        return false;
    }
}

