/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.EnvVars;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import jenkins.metrics.impl.TimeInQueueAction;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.apache.commons.lang3.StringUtils;

public class JenkinsBasePointGenerator
extends AbstractPointGenerator {
    public static final String BUILD_TIME = "build_time";
    public static final String BUILD_STATUS_MESSAGE = "build_status_message";
    public static final String TIME_IN_QUEUE = "time_in_queue";
    public static final String BUILD_SCHEDULED_TIME = "build_scheduled_time";
    public static final String BUILD_EXEC_TIME = "build_exec_time";
    public static final String BUILD_MEASURED_TIME = "build_measured_time";
    public static final String BUILD_RESULT = "build_result";
    public static final String BUILD_RESULT_ORDINAL = "build_result_ordinal";
    public static final String BUILD_IS_SUCCESSFUL = "build_successful";
    public static final String BUILD_AGENT_NAME = "build_agent_name";
    public static final String BUILD_BRANCH_NAME = "build_branch_name";
    public static final String BUILD_CAUSER = "build_causer";
    public static final String BUILD_USER = "build_user";
    public static final String BUILD_CAUSE = "build_cause";
    public static final String PROJECT_BUILD_HEALTH = "project_build_health";
    public static final String PROJECT_LAST_SUCCESSFUL = "last_successful_build";
    public static final String PROJECT_LAST_STABLE = "last_stable_build";
    public static final String TESTS_FAILED = "tests_failed";
    public static final String TESTS_SKIPPED = "tests_skipped";
    public static final String TESTS_TOTAL = "tests_total";
    public static final String AGENT_LOG_PATTERN = "Running on ";
    private final Run<?, ?> build;
    private final String customPrefix;
    private final String jenkinsEnvParameterField;
    private final String measurementName;
    private EnvVars env;

    public JenkinsBasePointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String jenkinsEnvParameterField, String customPrefix, String measurementName, EnvVars env) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.build = build;
        this.customPrefix = customPrefix;
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
        this.measurementName = measurementName;
        this.env = env;
    }

    @Override
    public boolean hasReport() {
        return true;
    }

    @Override
    public AbstractPoint[] generate() {
        int ordinal;
        String result;
        long startTime = this.build.getTimeInMillis();
        long currTime = System.currentTimeMillis();
        long dt = currTime - startTime;
        Result buildResult = this.build.getResult();
        if (buildResult == null) {
            result = "?";
            ordinal = 5;
        } else {
            result = buildResult.toString();
            ordinal = buildResult.ordinal;
        }
        String[] buildCause = this.getCauseDatas();
        AbstractPoint point = this.buildPoint(this.measurementName, this.customPrefix, this.build);
        point.addField(BUILD_TIME, this.build.getDuration() == 0L ? dt : this.build.getDuration()).addField(BUILD_SCHEDULED_TIME, this.build.getTimeInMillis()).addField(BUILD_EXEC_TIME, this.build.getStartTimeInMillis()).addField(BUILD_MEASURED_TIME, currTime).addField(BUILD_STATUS_MESSAGE, this.build.getBuildStatusSummary().message).addField(BUILD_RESULT_ORDINAL, ordinal).addField(BUILD_IS_SUCCESSFUL, ordinal < 2).addField(BUILD_AGENT_NAME, this.getNodeName()).addField(BUILD_BRANCH_NAME, this.getBuildEnv("BRANCH_NAME")).addField(PROJECT_BUILD_HEALTH, this.build.getParent().getBuildHealth().getScore()).addField(PROJECT_LAST_SUCCESSFUL, this.getLastSuccessfulBuild()).addField(PROJECT_LAST_STABLE, this.getLastStableBuild()).addField(BUILD_CAUSER, this.getCauseShortDescription()).addField(BUILD_USER, buildCause[0]).addField(BUILD_CAUSE, buildCause[1]).addTag(BUILD_RESULT, result);
        if (this.hasTestResults(this.build)) {
            point.addField(TESTS_FAILED, ((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getFailCount());
            point.addField(TESTS_SKIPPED, ((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getSkipCount());
            point.addField(TESTS_TOTAL, ((AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class)).getTotalCount());
        }
        if (this.hasMetricsPlugin(this.build)) {
            point.addField(TIME_IN_QUEUE, ((TimeInQueueAction)this.build.getAction(TimeInQueueAction.class)).getQueuingDurationMillis());
        }
        if (StringUtils.isNotBlank((CharSequence)this.jenkinsEnvParameterField)) {
            Properties fieldProperties = this.parsePropertiesString(this.jenkinsEnvParameterField);
            Map<String, Object> fieldMap = this.resolveEnvParameterAndTransformToMap(fieldProperties);
            point.addFields(fieldMap);
        }
        return new AbstractPoint[]{point};
    }

    private String[] getCauseDatas() {
        String userCause = "";
        StringJoiner triggers = new StringJoiner(", ");
        try {
            for (Cause cause : this.build.getCauses()) {
                triggers.add(cause.getClass().getSimpleName());
                if (cause instanceof Cause.UserIdCause) {
                    userCause = ((Cause.UserIdCause)cause).getUserId();
                    continue;
                }
                if (!cause.getClass().getName().contains("GitlabWebhookCause")) continue;
                userCause = (String)this.build.getEnvironment(this.listener).get((Object)"gitlabUserUsername");
            }
            return new String[]{userCause != null ? userCause : "", triggers.toString()};
        }
        catch (IOException | InterruptedException e) {
            return new String[]{"", ""};
        }
    }

    private String getNodeName() {
        String nodeName = this.getBuildEnv("NODE_NAME");
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            nodeName = this.getNodeNameFromLogs();
        }
        return nodeName;
    }

    private String getBuildEnv(String buildEnv) {
        String s = (String)this.env.get((Object)buildEnv);
        return s == null ? "" : s;
    }

    private int getLastSuccessfulBuild() {
        Run lastSuccessfulBuild = this.build.getParent().getLastSuccessfulBuild();
        return lastSuccessfulBuild != null ? lastSuccessfulBuild.getNumber() : 0;
    }

    private int getLastStableBuild() {
        Run lastStableBuild = this.build.getParent().getLastStableBuild();
        return lastStableBuild != null ? lastStableBuild.getNumber() : 0;
    }

    private String getCauseShortDescription() {
        try {
            List shortDescriptionList = this.build.getCauses();
            Cause shortDescription = (Cause)shortDescriptionList.get(0);
            return shortDescription != null ? shortDescription.getShortDescription() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean hasTestResults(Run<?, ?> build) {
        return build.getAction(AbstractTestResultAction.class) != null;
    }

    private boolean hasMetricsPlugin(Run<?, ?> build) {
        try {
            return build.getAction(TimeInQueueAction.class) != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private String getNodeNameFromLogs() {
        String agentName = "";
        try (BufferedReader br = new BufferedReader(this.build.getLogReader());){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(AGENT_LOG_PATTERN)) continue;
                String[] splitLine = line.split(" ");
                agentName = splitLine.length >= 3 ? splitLine[2] : "";
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return agentName;
    }
}

