/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb.generators;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkinsci.plugins.influxdb.generators.AbstractPointGenerator;
import jenkinsci.plugins.influxdb.models.AbstractPoint;
import jenkinsci.plugins.influxdb.renderer.ProjectNameRenderer;
import org.apache.commons.collections.CollectionUtils;

public class GitPointGenerator
extends AbstractPointGenerator {
    protected static final String GIT_REPOSITORY = "git_repository";
    protected static final String GIT_REVISION = "git_revision";
    protected static final String GIT_REFERENCE = "git_reference";
    protected static final String UNIQUE_ID = "unique_id";
    private String customPrefix;
    private List<BuildData> gitActions;

    public GitPointGenerator(Run<?, ?> build, TaskListener listener, ProjectNameRenderer projectNameRenderer, long timestamp, String jenkinsEnvParameterTag, String customPrefix) {
        super(build, listener, projectNameRenderer, timestamp, jenkinsEnvParameterTag);
        this.customPrefix = customPrefix;
        this.gitActions = build.getActions(BuildData.class);
    }

    @Override
    public boolean hasReport() {
        return CollectionUtils.isNotEmpty(this.gitActions);
    }

    @Override
    public AbstractPoint[] generate() {
        ArrayList<AbstractPoint> points = new ArrayList<AbstractPoint>();
        String sha1String = null;
        String branchName = null;
        BuildData gitAction = null;
        for (int i = 0; i < this.gitActions.size(); ++i) {
            gitAction = this.gitActions.get(i);
            Revision revision = gitAction.getLastBuiltRevision();
            if (revision != null) {
                sha1String = revision.getSha1String();
                Collection branches = revision.getBranches();
                if (CollectionUtils.isNotEmpty((Collection)branches)) {
                    branchName = ((Branch)branches.iterator().next()).getName();
                }
            }
            AbstractPoint point = this.buildPoint("git_data", this.customPrefix, this.build).addTag(UNIQUE_ID, String.valueOf(i + 1)).addField(GIT_REPOSITORY, !CollectionUtils.isEmpty((Collection)gitAction.getRemoteUrls()) ? (String)gitAction.getRemoteUrls().iterator().next() : "").addField(GIT_REFERENCE, branchName).addField(GIT_REVISION, sha1String);
            points.add(point);
        }
        return points.toArray(new AbstractPoint[0]);
    }
}

