/*
 * Decompiled with CFR 0.152.
 */
package jenkinsci.plugins.influxdb;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkinsci.plugins.influxdb.InfluxDbGlobalConfig;
import jenkinsci.plugins.influxdb.InfluxDbPublicationService;
import jenkinsci.plugins.influxdb.models.Target;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InfluxDbPublisher
extends Notifier
implements SimpleBuildStep {
    public static final String DEFAULT_MEASUREMENT_NAME = "jenkins_data";
    private String selectedTarget;
    private String customProjectName;
    private String customPrefix;
    private Map<String, Object> customData;
    private Map<String, String> customDataTags;
    private Map<String, Map<String, Object>> customDataMap;
    private Map<String, Map<String, String>> customDataMapTags;
    private String jenkinsEnvParameterField;
    private String jenkinsEnvParameterTag;
    private String measurementName;
    private EnvVars env;

    @DataBoundConstructor
    public InfluxDbPublisher(String selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public String getSelectedTarget() {
        List<Target> targets;
        String target = this.selectedTarget;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (target == null && jenkins != null && !(targets = ((DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class)).getTargets()).isEmpty()) {
            target = targets.get(0).getDescription();
        }
        return target;
    }

    @DataBoundSetter
    public void setSelectedTarget(String target) {
        Objects.requireNonNull(target);
        this.selectedTarget = target;
    }

    public String getCustomProjectName() {
        return this.customProjectName;
    }

    @DataBoundSetter
    public void setCustomProjectName(String customProjectName) {
        this.customProjectName = customProjectName;
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    @DataBoundSetter
    public void setCustomPrefix(String customPrefix) {
        this.customPrefix = customPrefix;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @DataBoundSetter
    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }

    public Map<String, String> getCustomDataTags() {
        return this.customDataTags;
    }

    @DataBoundSetter
    public void setCustomDataTags(Map<String, String> customDataTags) {
        this.customDataTags = customDataTags;
    }

    public Map<String, Map<String, Object>> getCustomDataMap() {
        return this.customDataMap;
    }

    @DataBoundSetter
    public void setCustomDataMap(Map<String, Map<String, Object>> customDataMap) {
        this.customDataMap = customDataMap;
    }

    public Map<String, Map<String, String>> getCustomDataMapTags() {
        return this.customDataMapTags;
    }

    @DataBoundSetter
    public void setCustomDataMapTags(Map<String, Map<String, String>> customDataMapTags) {
        this.customDataMapTags = customDataMapTags;
    }

    public String getJenkinsEnvParameterField() {
        return this.jenkinsEnvParameterField;
    }

    @DataBoundSetter
    public void setJenkinsEnvParameterField(String jenkinsEnvParameterField) {
        this.jenkinsEnvParameterField = jenkinsEnvParameterField;
    }

    public String getJenkinsEnvParameterTag() {
        return this.jenkinsEnvParameterTag;
    }

    @DataBoundSetter
    public void setJenkinsEnvParameterTag(String jenkinsEnvParameterTag) {
        this.jenkinsEnvParameterTag = jenkinsEnvParameterTag;
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    @DataBoundSetter
    public void setMeasurementName(String measurementName) {
        this.measurementName = measurementName;
    }

    private String getMeasurementNameIfNotBlankOrDefault() {
        return this.measurementName != null ? this.measurementName : DEFAULT_MEASUREMENT_NAME;
    }

    public Target getTarget() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            List<Target> targets = ((DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class)).getTargets();
            if (this.selectedTarget == null && !targets.isEmpty()) {
                return targets.get(0);
            }
            for (Target target : targets) {
                String targetInfo = target.getDescription();
                if (!targetInfo.equals(this.selectedTarget)) continue;
                return target;
            }
        }
        return null;
    }

    public void setEnv(EnvVars env) {
        this.env = env;
    }

    public boolean prebuild(Run<?, ?> build, TaskListener listener) {
        return true;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull EnvVars envVars, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Target target = this.getTarget();
        if (target == null) {
            throw new RuntimeException("Target was null!");
        }
        long currTime = this.resolveTimestampForPointGenerationInNanoseconds(build);
        this.measurementName = this.getMeasurementNameIfNotBlankOrDefault();
        if (this.env == null) {
            this.env = envVars;
        }
        String expandedCustomPrefix = this.env.expand(this.customPrefix);
        String expandedCustomProjectName = this.env.expand(this.customProjectName);
        InfluxDbPublicationService publicationService = new InfluxDbPublicationService(Collections.singletonList(target), expandedCustomProjectName, expandedCustomPrefix, this.customData, this.customDataTags, this.customDataMapTags, this.customDataMap, currTime, this.jenkinsEnvParameterField, this.jenkinsEnvParameterTag, this.measurementName);
        publicationService.perform(build, listener, this.env);
    }

    private long resolveTimestampForPointGenerationInNanoseconds(Run<?, ?> build) {
        long timestamp = this.getTarget().isJobScheduledTimeAsPointsTimestamp() ? build.getTimeInMillis() : System.currentTimeMillis();
        return timestamp * 1000000L;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements ModelObject {
        private List<Target> targets = new CopyOnWriteArrayList<Target>();

        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        @Deprecated
        public Target[] getDeprecatedTargets() {
            return this.targets.toArray(new Target[0]);
        }

        @DataBoundSetter
        @Deprecated
        public void setDeprecatedTargets(List<Target> targets) {
            this.targets = targets;
        }

        public List<Target> getTargets() {
            return InfluxDbGlobalConfig.getInstance().getTargets();
        }

        @Nonnull
        public String getDisplayName() {
            return "Publish build data to InfluxDB";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillSelectedTargetItems() {
            ListBoxModel model = new ListBoxModel();
            for (Target target : this.getTargets()) {
                model.add(target.getDescription());
            }
            return model;
        }

        void removeDeprecatedTargets() {
            this.targets = new CopyOnWriteArrayList<Target>();
        }
    }
}

