/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.util.regex.Pattern;

public class GradleOutcomeNote
extends ConsoleNote {
    private static final Pattern BUILD_RESULT_PATTERN = Pattern.compile("^(BUILD \\S*)");

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        MarkupText.SubText t = text.findToken(BUILD_RESULT_PATTERN);
        if (t == null) {
            return null;
        }
        String buildStatus = t.group(1);
        if (text.getText().contains("FAIL")) {
            text.addMarkup(0, buildStatus.length(), "<span class=gradle-outcome-failure>", "</span>");
        }
        if (text.getText().contains("SUCCESS")) {
            text.addMarkup(0, buildStatus.length(), "<span class=gradle-outcome-success>", "</span>");
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "Gradle build outcome";
        }
    }
}

