/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Run;
import hudson.plugins.gradle.BuildScanLogScanner;
import hudson.plugins.gradle.DefaultBuildScanPublishedListener;
import java.io.BufferedReader;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildScanPublisher
extends Step {
    @DataBoundConstructor
    public BuildScanPublisher() {
    }

    public StepExecution start(StepContext context) {
        return new Execution(context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class);
        }

        @Nonnull
        public String getDisplayName() {
            return "Find published build scans";
        }

        public String getFunctionName() {
            return "findBuildScans";
        }
    }

    static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;

        protected Execution(@Nonnull StepContext context) {
            super(context);
        }

        protected Void run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            BuildScanLogScanner scanner = new BuildScanLogScanner(new DefaultBuildScanPublishedListener((Actionable)run));
            try (BufferedReader logReader = new BufferedReader(run.getLogReader());
                 Stream<String> lines = logReader.lines();){
                lines.forEach(scanner::scanLine);
            }
            return null;
        }
    }
}

