/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.util;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.jenkins.plugins.util.ConflictException;
import com.google.jenkins.plugins.util.ExecutorException;
import com.google.jenkins.plugins.util.ForbiddenException;
import com.google.jenkins.plugins.util.MaxRetryExceededException;
import com.google.jenkins.plugins.util.Messages;
import com.google.jenkins.plugins.util.NotFoundException;
import com.google.jenkins.plugins.util.RequestCallable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Executor {
    private static final Logger logger = Logger.getLogger(Executor.class.getName());
    private static final long SLEEP_DURATION_SECONDS = 15L;

    public <T> T execute(AbstractGoogleJsonClientRequest<T> request) throws IOException, ExecutorException {
        return this.execute(RequestCallable.from(request));
    }

    public abstract <T> T execute(RequestCallable<T> var1) throws IOException, ExecutorException;

    public void sleep() {
        Uninterruptibles.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void sleep(int retryAttempt) {
        this.sleep();
    }

    public static class Default
    extends Executor {
        private boolean composeRetry;
        private final int maxRetry;
        private static final int RETRY_COUNT = 5;

        public Default() {
            this(5, true);
        }

        public Default(int maxRetry, boolean composeRetry) {
            this.maxRetry = maxRetry;
            this.composeRetry = composeRetry;
        }

        private int getMaxRetry() {
            return this.maxRetry;
        }

        private IOException propagateRetry(IOException lastException) throws IOException, ExecutorException {
            if (this.composeRetry) {
                throw lastException;
            }
            throw new MaxRetryExceededException(lastException);
        }

        @Override
        public <T> T execute(RequestCallable<T> block) throws IOException, ExecutorException {
            Throwable lastException = null;
            for (int i = 0; i < this.getMaxRetry(); ++i) {
                try {
                    return ((RequestCallable)Preconditions.checkNotNull(block)).call();
                }
                catch (HttpResponseException e) {
                    lastException = e;
                    if (e.getStatusCode() == 404) {
                        throw new NotFoundException(e);
                    }
                    if (e.getStatusCode() == 403) {
                        throw new ForbiddenException(e);
                    }
                    if (e.getStatusCode() == 409) {
                        throw new ConflictException(e);
                    }
                    logger.log(Level.SEVERE, Messages.Executor_HttpError(), e);
                }
                catch (SocketTimeoutException e) {
                    logger.log(Level.SEVERE, Messages.Executor_TimeoutError(), e);
                    lastException = e;
                }
                if (!block.canRetry()) break;
                this.sleep(i);
            }
            throw this.propagateRetry((IOException)Preconditions.checkNotNull(lastException));
        }
    }
}

