/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.SecretBytes;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Describable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;

public abstract class ServiceAccountConfig
implements Describable<ServiceAccountConfig>,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ServiceAccountConfig.class.getName());
    private static final long serialVersionUID = 6355493019938144806L;

    public abstract String getAccountId();

    public abstract PrivateKey getPrivateKey();

    @Deprecated
    @CheckForNull
    protected SecretBytes getSecretBytesFromFile(@CheckForNull String filePath) {
        Jenkins.get().checkPermission(Jenkins.RUN_SCRIPTS);
        if (Strings.isNullOrEmpty((String)filePath)) {
            LOGGER.log(Level.SEVERE, "Provided file path is null or empty.");
            return null;
        }
        try {
            return SecretBytes.fromBytes((byte[])FileUtils.readFileToByteArray((File)new File(filePath)));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed to read previous key from %s", filePath), e);
            return null;
        }
    }

    public static abstract class Descriptor
    extends hudson.model.Descriptor<ServiceAccountConfig> {
    }
}

