// CHECKSTYLE:OFF

package com.google.jenkins.plugins.credentials.oauth;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code P12ServiceAccountConfig.ErrorEmailRequired}: {@code Email
     * address is required}.
     * 
     * @return
     *     {@code Email address is required}
     */
    public static String P12ServiceAccountConfig_ErrorEmailRequired() {
        return holder.format("P12ServiceAccountConfig.ErrorEmailRequired");
    }

    /**
     * Key {@code P12ServiceAccountConfig.ErrorEmailRequired}: {@code Email
     * address is required}.
     * 
     * @return
     *     {@code Email address is required}
     */
    public static Localizable _P12ServiceAccountConfig_ErrorEmailRequired() {
        return new Localizable(holder, "P12ServiceAccountConfig.ErrorEmailRequired");
    }

    /**
     * Key {@code P12ServiceAccountConfig.DisplayName}: {@code P12 key}.
     * 
     * @return
     *     {@code P12 key}
     */
    public static String P12ServiceAccountConfig_DisplayName() {
        return holder.format("P12ServiceAccountConfig.DisplayName");
    }

    /**
     * Key {@code P12ServiceAccountConfig.DisplayName}: {@code P12 key}.
     * 
     * @return
     *     {@code P12 key}
     */
    public static Localizable _P12ServiceAccountConfig_DisplayName() {
        return new Localizable(holder, "P12ServiceAccountConfig.DisplayName");
    }

    /**
     * Key {@code GoogleRobotCredentials.NoAnnotation}: {@code {0} must be
     * annotated with @RequiresDomain}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} must be annotated with @RequiresDomain}
     */
    public static String GoogleRobotCredentials_NoAnnotation(Object arg0) {
        return holder.format("GoogleRobotCredentials.NoAnnotation", arg0);
    }

    /**
     * Key {@code GoogleRobotCredentials.NoAnnotation}: {@code {0} must be
     * annotated with @RequiresDomain}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} must be annotated with @RequiresDomain}
     */
    public static Localizable _GoogleRobotCredentials_NoAnnotation(Object arg0) {
        return new Localizable(holder, "GoogleRobotCredentials.NoAnnotation", arg0);
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.BadCredentials}: {@code An
     * error occurred deducing a username from the provided credentials
     * files.}.
     * 
     * @return
     *     {@code An error occurred deducing a username from the provided
     *     credentials files.}
     */
    public static String GoogleRobotPrivateKeyCredentials_BadCredentials() {
        return holder.format("GoogleRobotPrivateKeyCredentials.BadCredentials");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.BadCredentials}: {@code An
     * error occurred deducing a username from the provided credentials
     * files.}.
     * 
     * @return
     *     {@code An error occurred deducing a username from the provided
     *     credentials files.}
     */
    public static Localizable _GoogleRobotPrivateKeyCredentials_BadCredentials() {
        return new Localizable(holder, "GoogleRobotPrivateKeyCredentials.BadCredentials");
    }

    /**
     * Key {@code GoogleAuthorizationStrategy.CredentialError}: {@code Need
     * to provide a credential}.
     * 
     * @return
     *     {@code Need to provide a credential}
     */
    public static String GoogleAuthorizationStrategy_CredentialError() {
        return holder.format("GoogleAuthorizationStrategy.CredentialError");
    }

    /**
     * Key {@code GoogleAuthorizationStrategy.CredentialError}: {@code Need
     * to provide a credential}.
     * 
     * @return
     *     {@code Need to provide a credential}
     */
    public static Localizable _GoogleAuthorizationStrategy_CredentialError() {
        return new Localizable(holder, "GoogleAuthorizationStrategy.CredentialError");
    }

    /**
     * Key {@code RemotableGoogleCredentials.NoAccessToken}: {@code Unable to
     * retrieve an access token with the provided credentials}.
     * 
     * @return
     *     {@code Unable to retrieve an access token with the provided
     *     credentials}
     */
    public static String RemotableGoogleCredentials_NoAccessToken() {
        return holder.format("RemotableGoogleCredentials.NoAccessToken");
    }

    /**
     * Key {@code RemotableGoogleCredentials.NoAccessToken}: {@code Unable to
     * retrieve an access token with the provided credentials}.
     * 
     * @return
     *     {@code Unable to retrieve an access token with the provided
     *     credentials}
     */
    public static Localizable _RemotableGoogleCredentials_NoAccessToken() {
        return new Localizable(holder, "RemotableGoogleCredentials.NoAccessToken");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.DefaultIdentityError}:
     * {@code An unknown problem occured while retrieving the default service
     * account's identity}.
     * 
     * @return
     *     {@code An unknown problem occured while retrieving the default service
     *     account's identity}
     */
    public static String GoogleRobotMetadataCredentials_DefaultIdentityError() {
        return holder.format("GoogleRobotMetadataCredentials.DefaultIdentityError");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.DefaultIdentityError}:
     * {@code An unknown problem occured while retrieving the default service
     * account's identity}.
     * 
     * @return
     *     {@code An unknown problem occured while retrieving the default service
     *     account's identity}
     */
    public static Localizable _GoogleRobotMetadataCredentials_DefaultIdentityError() {
        return new Localizable(holder, "GoogleRobotMetadataCredentials.DefaultIdentityError");
    }

    /**
     * Key {@code JsonServiceAccountConfig.DisplayName}: {@code JSON key}.
     * 
     * @return
     *     {@code JSON key}
     */
    public static String JsonServiceAccountConfig_DisplayName() {
        return holder.format("JsonServiceAccountConfig.DisplayName");
    }

    /**
     * Key {@code JsonServiceAccountConfig.DisplayName}: {@code JSON key}.
     * 
     * @return
     *     {@code JSON key}
     */
    public static Localizable _JsonServiceAccountConfig_DisplayName() {
        return new Localizable(holder, "JsonServiceAccountConfig.DisplayName");
    }

    /**
     * Key {@code RemotableGoogleCredentials.BadGetName}: {@code Consumers of
     * RemotableGoogleCredentials should not invoke getName}.
     * 
     * @return
     *     {@code Consumers of RemotableGoogleCredentials should not invoke
     *     getName}
     */
    public static String RemotableGoogleCredentials_BadGetName() {
        return holder.format("RemotableGoogleCredentials.BadGetName");
    }

    /**
     * Key {@code RemotableGoogleCredentials.BadGetName}: {@code Consumers of
     * RemotableGoogleCredentials should not invoke getName}.
     * 
     * @return
     *     {@code Consumers of RemotableGoogleCredentials should not invoke
     *     getName}
     */
    public static Localizable _RemotableGoogleCredentials_BadGetName() {
        return new Localizable(holder, "RemotableGoogleCredentials.BadGetName");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.ExceptionString}: {@code
     * An unknown problem occured while retrieving token}.
     * 
     * @return
     *     {@code An unknown problem occured while retrieving token}
     */
    public static String GoogleRobotPrivateKeyCredentials_ExceptionString() {
        return holder.format("GoogleRobotPrivateKeyCredentials.ExceptionString");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.ExceptionString}: {@code
     * An unknown problem occured while retrieving token}.
     * 
     * @return
     *     {@code An unknown problem occured while retrieving token}
     */
    public static Localizable _GoogleRobotPrivateKeyCredentials_ExceptionString() {
        return new Localizable(holder, "GoogleRobotPrivateKeyCredentials.ExceptionString");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.DisplayName}: {@code
     * Google Service Account from private key}.
     * 
     * @return
     *     {@code Google Service Account from private key}
     */
    public static String GoogleRobotPrivateKeyCredentials_DisplayName() {
        return holder.format("GoogleRobotPrivateKeyCredentials.DisplayName");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.DisplayName}: {@code
     * Google Service Account from private key}.
     * 
     * @return
     *     {@code Google Service Account from private key}
     */
    public static Localizable _GoogleRobotPrivateKeyCredentials_DisplayName() {
        return new Localizable(holder, "GoogleRobotPrivateKeyCredentials.DisplayName");
    }

    /**
     * Key {@code RemotableGoogleCredentials.BadGetDescriptor}: {@code
     * Consumers of RemotableGoogleCredentials should not invoke
     * getDescriptor}.
     * 
     * @return
     *     {@code Consumers of RemotableGoogleCredentials should not invoke
     *     getDescriptor}
     */
    public static String RemotableGoogleCredentials_BadGetDescriptor() {
        return holder.format("RemotableGoogleCredentials.BadGetDescriptor");
    }

    /**
     * Key {@code RemotableGoogleCredentials.BadGetDescriptor}: {@code
     * Consumers of RemotableGoogleCredentials should not invoke
     * getDescriptor}.
     * 
     * @return
     *     {@code Consumers of RemotableGoogleCredentials should not invoke
     *     getDescriptor}
     */
    public static Localizable _RemotableGoogleCredentials_BadGetDescriptor() {
        return new Localizable(holder, "RemotableGoogleCredentials.BadGetDescriptor");
    }

    /**
     * Key {@code GoogleAuthorizationStrategy.DisplayName}: {@code Project
     * Matrix Authorization Strategy (using Google Cloud Console roles)}.
     * 
     * @return
     *     {@code Project Matrix Authorization Strategy (using Google Cloud
     *     Console roles)}
     */
    public static String GoogleAuthorizationStrategy_DisplayName() {
        return holder.format("GoogleAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code GoogleAuthorizationStrategy.DisplayName}: {@code Project
     * Matrix Authorization Strategy (using Google Cloud Console roles)}.
     * 
     * @return
     *     {@code Project Matrix Authorization Strategy (using Google Cloud
     *     Console roles)}
     */
    public static Localizable _GoogleAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "GoogleAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.ProjectIDError}: {@code A
     * project name must be specified}.
     * 
     * @return
     *     {@code A project name must be specified}
     */
    public static String GoogleRobotPrivateKeyCredentials_ProjectIDError() {
        return holder.format("GoogleRobotPrivateKeyCredentials.ProjectIDError");
    }

    /**
     * Key {@code GoogleRobotPrivateKeyCredentials.ProjectIDError}: {@code A
     * project name must be specified}.
     * 
     * @return
     *     {@code A project name must be specified}
     */
    public static Localizable _GoogleRobotPrivateKeyCredentials_ProjectIDError() {
        return new Localizable(holder, "GoogleRobotPrivateKeyCredentials.ProjectIDError");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.DisplayName}: {@code Google
     * Service Account from metadata}.
     * 
     * @return
     *     {@code Google Service Account from metadata}
     */
    public static String GoogleRobotMetadataCredentials_DisplayName() {
        return holder.format("GoogleRobotMetadataCredentials.DisplayName");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.DisplayName}: {@code Google
     * Service Account from metadata}.
     * 
     * @return
     *     {@code Google Service Account from metadata}
     */
    public static Localizable _GoogleRobotMetadataCredentials_DisplayName() {
        return new Localizable(holder, "GoogleRobotMetadataCredentials.DisplayName");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.AddProjectIdAuthError}:
     * {@code Insufficient privileges to add a project}.
     * 
     * @return
     *     {@code Insufficient privileges to add a project}
     */
    public static String GoogleRobotMetadataCredentials_AddProjectIdAuthError() {
        return holder.format("GoogleRobotMetadataCredentials.AddProjectIdAuthError");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.AddProjectIdAuthError}:
     * {@code Insufficient privileges to add a project}.
     * 
     * @return
     *     {@code Insufficient privileges to add a project}
     */
    public static Localizable _GoogleRobotMetadataCredentials_AddProjectIdAuthError() {
        return new Localizable(holder, "GoogleRobotMetadataCredentials.AddProjectIdAuthError");
    }

    /**
     * Key {@code GoogleOAuth2ScopeSpecification.DisplayName}: {@code Google
     * OAuth 2.0 Scope Specification}.
     * 
     * @return
     *     {@code Google OAuth 2.0 Scope Specification}
     */
    public static String GoogleOAuth2ScopeSpecification_DisplayName() {
        return holder.format("GoogleOAuth2ScopeSpecification.DisplayName");
    }

    /**
     * Key {@code GoogleOAuth2ScopeSpecification.DisplayName}: {@code Google
     * OAuth 2.0 Scope Specification}.
     * 
     * @return
     *     {@code Google OAuth 2.0 Scope Specification}
     */
    public static Localizable _GoogleOAuth2ScopeSpecification_DisplayName() {
        return new Localizable(holder, "GoogleOAuth2ScopeSpecification.DisplayName");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.ProjectIDError}: {@code A
     * project name must be specified}.
     * 
     * @return
     *     {@code A project name must be specified}
     */
    public static String GoogleRobotMetadataCredentials_ProjectIDError() {
        return holder.format("GoogleRobotMetadataCredentials.ProjectIDError");
    }

    /**
     * Key {@code GoogleRobotMetadataCredentials.ProjectIDError}: {@code A
     * project name must be specified}.
     * 
     * @return
     *     {@code A project name must be specified}
     */
    public static Localizable _GoogleRobotMetadataCredentials_ProjectIDError() {
        return new Localizable(holder, "GoogleRobotMetadataCredentials.ProjectIDError");
    }

    /**
     * Key {@code GoogleRobotCredentials.Description}: {@code A Google robot
     * account for accessing Google APIs and services.}.
     * 
     * @return
     *     {@code A Google robot account for accessing Google APIs and services.}
     */
    public static String GoogleRobotCredentials_Description() {
        return holder.format("GoogleRobotCredentials.Description");
    }

    /**
     * Key {@code GoogleRobotCredentials.Description}: {@code A Google robot
     * account for accessing Google APIs and services.}.
     * 
     * @return
     *     {@code A Google robot account for accessing Google APIs and services.}
     */
    public static Localizable _GoogleRobotCredentials_Description() {
        return new Localizable(holder, "GoogleRobotCredentials.Description");
    }

}
