/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.User;
import hudson.model.UserProperty;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.GithubAccessTokenProperty;

public class GithubSecretStorage {
    private static final Logger LOGGER = Logger.getLogger(GithubSecretStorage.class.getName());

    private GithubSecretStorage() {
    }

    public static boolean contains(@NonNull User user) {
        return user.getProperty(GithubAccessTokenProperty.class) != null;
    }

    @CheckForNull
    public static String retrieve(@NonNull User user) {
        GithubAccessTokenProperty property = (GithubAccessTokenProperty)user.getProperty(GithubAccessTokenProperty.class);
        if (property == null) {
            LOGGER.log(Level.FINE, "Cache miss for username: " + user.getId());
            return null;
        }
        LOGGER.log(Level.FINE, "Token retrieved using cache for username: " + user.getId());
        return property.getAccessToken().getPlainText();
    }

    public static void put(@NonNull User user, @NonNull String accessToken) {
        LOGGER.log(Level.FINE, "Populating the cache for username: " + user.getId());
        try {
            user.addProperty((UserProperty)new GithubAccessTokenProperty(accessToken));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Received an exception when trying to add the GitHub access token to the user: " + user.getId(), e);
        }
    }
}

