/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.gwt.GenericCause;

@Extension
public class GenericWebhookEnvironmentContributor
extends EnvironmentContributor {
    public void buildEnvironmentFor(@NonNull Run r, @NonNull EnvVars envs, @NonNull TaskListener listener) throws IOException, InterruptedException {
        GenericCause cause = (GenericCause)r.getCause(GenericCause.class);
        if (cause != null) {
            boolean shouldLog;
            boolean bl = shouldLog = (cause.isPrintContributedVariables() || cause.isPrintPostContent()) && !cause.isPostContentPrinted();
            if (shouldLog) {
                cause.setPostContentPrinted(true);
            }
            if (shouldLog && cause.isPrintPostContent()) {
                listener.getLogger().println(" Received:\n\n" + cause.getPostContent() + "\n\n");
            }
            Map<String, String> resolvedVariables = cause.getResolvedVariables();
            if (shouldLog && cause.isPrintContributedVariables()) {
                listener.getLogger().println("Contributing variables:\n");
            }
            for (String variable : resolvedVariables.keySet()) {
                String resolved = cause.getResolvedVariables().get(variable);
                if (shouldLog && cause.isPrintContributedVariables()) {
                    listener.getLogger().println("    " + variable + " = " + resolved);
                }
                envs.override(variable, resolved);
            }
            if (shouldLog && cause.isPrintContributedVariables()) {
                listener.getLogger().println("\n");
            }
        }
    }
}

