/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.flexible_publish;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jenkins_ci.plugins.flexible_publish.ConditionalPublisher;
import org.jenkins_ci.plugins.flexible_publish.DefaultPublisherDescriptorLister;
import org.jenkins_ci.plugins.flexible_publish.FlexiblePublisher;
import org.jenkins_ci.plugins.flexible_publish.Messages;
import org.jenkins_ci.plugins.run_condition.BuildStepRunner;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.core.AlwaysRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobUpdater {
    public static boolean movePublisher(AbstractProject<?, ?> project, String publisherName) throws IOException {
        if (project == null) {
            throw new RuntimeException(Messages.jobUpdated_theProjectIsNull());
        }
        DescribableList publishers = project.getPublishersList();
        Publisher target = null;
        for (Publisher pub : publishers) {
            if (!pub.getDescriptor().getDisplayName().equalsIgnoreCase(publisherName)) continue;
            target = pub;
        }
        if (target == null) {
            throw new RuntimeException(JobUpdater.format(Messages.jobUpdater_publisherNotFound(publisherName), publishers.toList()));
        }
        List<? extends Descriptor<? extends BuildStep>> allowed = JobUpdater.getAllowedPublishers(project);
        if (!allowed.contains(target.getDescriptor())) {
            throw new RuntimeException(Messages.jobUpdater_publisherNotAllowed(publisherName));
        }
        ConditionalPublisher wrapped = new ConditionalPublisher((RunCondition)new AlwaysRun(), (BuildStep)target, (BuildStepRunner)new BuildStepRunner.Fail());
        publishers.remove((Object)target);
        JobUpdater.getOrCreateFlexiblePublisher((DescribableList<Publisher, Descriptor<Publisher>>)publishers).getPublishers().add(wrapped);
        return true;
    }

    public static boolean moveAllPublishers(AbstractProject<?, ?> project) throws IOException {
        if (project == null) {
            throw new RuntimeException(Messages.jobUpdated_theProjectIsNull());
        }
        DescribableList publishers = project.getPublishersList();
        List<? extends Descriptor<? extends BuildStep>> allowed = JobUpdater.getAllowedPublishers(project);
        ArrayList<ConditionalPublisher> wrapped = new ArrayList<ConditionalPublisher>();
        for (Publisher publisher : publishers) {
            if (!allowed.contains(publisher.getDescriptor())) continue;
            publishers.remove((Object)publisher);
            wrapped.add(new ConditionalPublisher((RunCondition)new AlwaysRun(), (BuildStep)publisher, (BuildStepRunner)new BuildStepRunner.Fail()));
        }
        if (wrapped.size() > 0) {
            JobUpdater.getOrCreateFlexiblePublisher((DescribableList<Publisher, Descriptor<Publisher>>)publishers).getPublishers().addAll(wrapped);
        }
        return true;
    }

    private static FlexiblePublisher getOrCreateFlexiblePublisher(DescribableList<Publisher, Descriptor<Publisher>> publishers) throws IOException {
        FlexiblePublisher flex = (FlexiblePublisher)publishers.get(FlexiblePublisher.class);
        if (flex == null) {
            flex = new FlexiblePublisher(new ArrayList<ConditionalPublisher>());
            ArrayList<FlexiblePublisher> replacement = new ArrayList<FlexiblePublisher>(publishers.toList());
            replacement.add(0, flex);
            publishers.replaceBy(replacement);
        }
        return flex;
    }

    public static String list(AbstractProject<?, ?> project) {
        return JobUpdater.list(project, true) + System.getProperty("line.separator") + JobUpdater.list(project, false);
    }

    public static String listCanMove(AbstractProject<?, ?> project) {
        return JobUpdater.list(project, true);
    }

    public static String listCannotMove(AbstractProject<?, ?> project) {
        return JobUpdater.list(project, false);
    }

    public static String list(AbstractProject<?, ?> project, boolean listCanMove) {
        if (project == null) {
            return Messages.jobUpdated_theProjectIsNull();
        }
        List<? extends Descriptor<? extends BuildStep>> allowed = JobUpdater.getAllowedPublishers(project);
        ArrayList<Publisher> selected = new ArrayList<Publisher>();
        for (Publisher pub : project.getPublishersList()) {
            if (listCanMove != allowed.contains(pub.getDescriptor())) continue;
            selected.add(pub);
        }
        return JobUpdater.format(listCanMove ? Messages.jobUpdater_canMovePublishers() : Messages.jobUpdater_cannotMovePublishers(), selected);
    }

    private static List<? extends Descriptor<? extends BuildStep>> getAllowedPublishers(AbstractProject<?, ?> project) {
        return new DefaultPublisherDescriptorLister().getAllowedPublishers(project);
    }

    private static String format(String header, List<Publisher> publishers) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        printer.println(header);
        JobUpdater.append(printer, publishers);
        return writer.toString();
    }

    private static void append(PrintWriter printWriter, List<Publisher> publishers) {
        for (Publisher pub : publishers) {
            printWriter.println("\t[" + pub.getDescriptor().getDisplayName() + "]");
        }
    }
}

