/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.flexible_publish;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.sf.json.JSONObject;
import org.jenkins_ci.plugins.flexible_publish.ConditionalPublisher;
import org.jenkins_ci.plugins.flexible_publish.DefaultPublisherDescriptorLister;
import org.jenkins_ci.plugins.flexible_publish.Messages;
import org.jenkins_ci.plugins.flexible_publish.PublisherDescriptorLister;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexiblePublisher
extends Recorder {
    public static final String PROMOTION_JOB_TYPE = "hudson.plugins.promoted_builds.PromotionProcess";
    private ArrayList<ConditionalPublisher> publishers;

    @DataBoundConstructor
    public FlexiblePublisher(ArrayList<ConditionalPublisher> publishers) {
        this.publishers = publishers;
    }

    public ArrayList<ConditionalPublisher> getPublishers() {
        return this.publishers;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        HashSet<BuildStepMonitor> monitors = new HashSet<BuildStepMonitor>();
        for (ConditionalPublisher cp : this.publishers) {
            monitors.add(cp.getPublisher().getRequiredMonitorService());
        }
        if (monitors.contains(BuildStepMonitor.BUILD)) {
            return BuildStepMonitor.BUILD;
        }
        if (monitors.contains(BuildStepMonitor.STEP)) {
            return BuildStepMonitor.STEP;
        }
        return BuildStepMonitor.NONE;
    }

    public Collection getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<? extends Action> actions = new ArrayList<Action>();
        for (ConditionalPublisher publisher : this.publishers) {
            actions.addAll(publisher.getProjectActions(project));
        }
        return actions;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (ConditionalPublisher publisher : this.publishers) {
            if (publisher.prebuild(build, listener)) continue;
            FlexiblePublisher.setResult(build, Result.FAILURE);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (ConditionalPublisher publisher : this.publishers) {
            if (publisher.perform(build, launcher, listener)) continue;
            FlexiblePublisher.setResult(build, Result.FAILURE);
        }
        return true;
    }

    private static void setResult(AbstractBuild<?, ?> build, Result result) {
        if (build.getResult() == null) {
            build.setResult(result);
        } else {
            build.setResult(result.combine(build.getResult()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=2.147483147E9)
    public static class FlexiblePublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        private PublisherDescriptorLister publisherLister;

        public static DescriptorExtensionList<PublisherDescriptorLister, Descriptor<PublisherDescriptorLister>> getAllPublisherDescriptorListers() {
            return Hudson.getInstance().getDescriptorList(PublisherDescriptorLister.class);
        }

        @DataBoundConstructor
        public FlexiblePublisherDescriptor(PublisherDescriptorLister publisherLister) {
            this.publisherLister = publisherLister;
        }

        public FlexiblePublisherDescriptor() {
            this.load();
            if (this.publisherLister == null) {
                this.publisherLister = new DefaultPublisherDescriptorLister();
            }
        }

        public PublisherDescriptorLister getPublisherLister() {
            return this.publisherLister;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            FlexiblePublisherDescriptor newConfig = (FlexiblePublisherDescriptor)((Object)req.bindJSON(FlexiblePublisherDescriptor.class, json));
            if (newConfig.publisherLister != null) {
                this.publisherLister = newConfig.publisherLister;
            }
            this.save();
            return true;
        }

        public String getDisplayName() {
            return Messages.publisher_displayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return !MatrixProject.class.equals(aClass) && !FlexiblePublisher.PROMOTION_JOB_TYPE.equals(aClass.getCanonicalName());
        }

        public Object readResolve() {
            if (this.publisherLister == null) {
                this.publisherLister = new DefaultPublisherDescriptorLister();
            }
            return this;
        }
    }
}

