/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.flexible_publish;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jenkins_ci.plugins.flexible_publish.Messages;
import org.jenkins_ci.plugins.flexible_publish.PublisherDescriptorLister;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPublisherDescriptorLister
implements PublisherDescriptorLister {
    public static final List<String> EXCLUSIONS = Arrays.asList("hudson.tasks.BuildTrigger.DescriptorImpl", "hudson.plugins.parameterizedtrigger.BuildTrigger.DescriptorImpl", "org.jenkins_ci.plugins.flexible_publish.FlexiblePublisher.FlexiblePublisherDescriptor");

    @DataBoundConstructor
    public DefaultPublisherDescriptorLister() {
    }

    @Override
    public List<? extends Descriptor<? extends BuildStep>> getAllowedPublishers(AbstractProject<?, ?> project) {
        ArrayList<BuildStepDescriptor> publishers = new ArrayList<BuildStepDescriptor>();
        if (project == null) {
            return publishers;
        }
        for (Descriptor descriptor : Publisher.all()) {
            BuildStepDescriptor buildStepDescriptor;
            if (!(descriptor instanceof BuildStepDescriptor) || EXCLUSIONS.contains(descriptor.getClass().getCanonicalName()) || !(buildStepDescriptor = (BuildStepDescriptor)descriptor).isApplicable(project.getClass()) || !this.hasDbc(buildStepDescriptor.clazz)) continue;
            publishers.add(buildStepDescriptor);
        }
        return publishers;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    private boolean hasDbc(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!constructor.isAnnotationPresent(DataBoundConstructor.class)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<PublisherDescriptorLister> {
        public String getDisplayName() {
            return Messages.defaultPublisherDescriptor_displayName();
        }
    }
}

