/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin;

import com.google.jenkins.flakyTestHandler.plugin.FlakyTestResultAction;
import com.google.jenkins.flakyTestHandler.plugin.HistoryAggregatedFlakyTestResultAction;
import com.google.jenkins.flakyTestHandler.plugin.TestFlakyStatsOverRevision;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class JUnitFlakyResultArchiver
extends Recorder
implements Serializable {
    @DataBoundConstructor
    public JUnitFlakyResultArchiver() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!project.isBuilding()) {
            HistoryAggregatedFlakyTestResultAction action = new HistoryAggregatedFlakyTestResultAction(project);
            action.aggregate();
            TestFlakyStatsOverRevision testFlakyStatsOverRevision = new TestFlakyStatsOverRevision(project, action);
            actions.add(testFlakyStatsOverRevision);
            actions.add(action);
        }
        return actions;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FlakyTestResultAction flakyStatCollectionAction = new FlakyTestResultAction(build, launcher, (TaskListener)listener);
        build.addAction((Action)flakyStatCollectionAction);
        if (flakyStatCollectionAction.getFlakyRunStats().isFlaked()) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish JUnit flaky stats";
        }

        public Publisher newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return new JUnitFlakyResultArchiver();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

