/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin;

import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyTestResult;
import com.google.jenkins.flakyTestHandler.plugin.FlakyTestResultCollector;
import com.google.jenkins.flakyTestHandler.plugin.HistoryAggregatedFlakyTestResultAction;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import hudson.Launcher;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.HeapSpaceStringConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;

public class FlakyTestResultAction
implements RunAction2 {
    private transient WeakReference<FlakyRunStats> flakyRunStats;
    private static final XStream XSTREAM = new XStream2();
    private AbstractBuild<?, ?> build;
    public static final Logger logger = Logger.getLogger(FlakyTestResultAction.class.getName());

    public FlakyTestResultAction(AbstractBuild build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.build = build;
        AbstractTestResultAction action = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        if (action != null) {
            Object latestResult = action.getResult();
            if (latestResult != null && latestResult instanceof TestResult) {
                VirtualChannel channel = launcher.getChannel();
                if (channel == null) {
                    throw new InterruptedException("Could not get channel to run a program remotely.");
                }
                FlakyTestResult flakyTestResult = (FlakyTestResult)((Object)channel.call((Callable)new FlakyTestResultCollector((TestResult)latestResult)));
                flakyTestResult.freeze(action, (Run)build);
                FlakyRunStats stats = new FlakyRunStats(flakyTestResult.getTestFlakyStatsMap());
                this.setFlakyRunStats(stats, listener);
            }
        } else {
            logger.log(Level.WARNING, "No test result found, please publish junit report first");
        }
    }

    FlakyTestResultAction() {
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.build.getRootDir(), "junitFlakyStatsResult.xml"));
    }

    private FlakyRunStats load() {
        FlakyRunStats stats;
        try {
            stats = (FlakyRunStats)this.getDataFile().read();
        }
        catch (IOException e) {
            stats = new FlakyRunStats();
        }
        return stats;
    }

    public void onAttached(Run<?, ?> r) {
        this.build = (AbstractBuild)r;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = (AbstractBuild)r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public synchronized FlakyRunStats getFlakyRunStats() {
        FlakyRunStats stats;
        if (this.flakyRunStats == null) {
            stats = this.load();
            this.flakyRunStats = new WeakReference<FlakyRunStats>(stats);
        } else {
            stats = (FlakyRunStats)this.flakyRunStats.get();
        }
        if (stats == null) {
            stats = this.load();
            this.flakyRunStats = new WeakReference<FlakyRunStats>(stats);
        }
        return stats;
    }

    synchronized void setFlakyRunStats(FlakyRunStats stats) {
        this.flakyRunStats = new WeakReference<FlakyRunStats>(stats);
    }

    public synchronized void setFlakyRunStats(FlakyRunStats stats, TaskListener listener) {
        try {
            this.getDataFile().write((Object)stats);
        }
        catch (IOException e) {
            e.printStackTrace(listener.fatalError("Failed to save the JUnit flaky test stats result"));
        }
        this.flakyRunStats = new WeakReference<FlakyRunStats>(stats);
    }

    public static Set<String> getTestIdFromTestResults(Collection<? extends hudson.tasks.test.TestResult> results) {
        HashSet<String> testIdSet = new HashSet<String>();
        for (hudson.tasks.test.TestResult testResult : results) {
            if (!(testResult instanceof FlakyCaseResult)) continue;
            testIdSet.add(((FlakyCaseResult)testResult).getFullDisplayName());
        }
        return testIdSet;
    }

    static {
        XSTREAM.registerConverter((SingleValueConverter)new HeapSpaceStringConverter(), 100);
    }

    public static class FlakyRunStats {
        Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> testFlakyStatsWithRevisionMap;

        public FlakyRunStats() {
            this.testFlakyStatsWithRevisionMap = new HashMap<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision>();
        }

        public FlakyRunStats(Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> testFlakyStatsWithRevisionMap) {
            this.testFlakyStatsWithRevisionMap = testFlakyStatsWithRevisionMap;
        }

        public Map<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> getTestFlakyStatsWithRevisionMap() {
            return this.testFlakyStatsWithRevisionMap;
        }

        public boolean isFlaked() {
            if (this.testFlakyStatsWithRevisionMap == null) {
                return false;
            }
            boolean seenFlake = false;
            for (Map.Entry<String, HistoryAggregatedFlakyTestResultAction.SingleTestFlakyStatsWithRevision> singleTestFlakyStatsWithRevisionEntry : this.testFlakyStatsWithRevisionMap.entrySet()) {
                if (singleTestFlakyStatsWithRevisionEntry.getValue().getStats().isFailed()) {
                    return false;
                }
                if (!singleTestFlakyStatsWithRevisionEntry.getValue().getStats().isFlaked()) continue;
                seenFlake = true;
            }
            return seenFlake;
        }
    }
}

