/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.plugins.fitnesse.FitnesseProjectAction;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.FitnesseResultsRecorder;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.plugins.fitnesse.NativePageCountsParser;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseResultsRecorder
extends Recorder {
    private final String fitnessePathToXmlResultsIn;

    @DataBoundConstructor
    public FitnesseResultsRecorder(String fitnessePathToXmlResultsIn) {
        this.fitnessePathToXmlResultsIn = fitnessePathToXmlResultsIn;
    }

    public String getFitnessePathToXmlResultsIn() {
        return this.fitnessePathToXmlResultsIn;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new FitnesseProjectAction(project));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            FilePath workingDirectory = FitnesseExecutor.getWorkingDirectory(build);
            FilePath resultsFile = FitnesseExecutor.getResultsFilePath((FilePath)workingDirectory, (String)this.fitnessePathToXmlResultsIn);
            FitnesseResults results = this.getResults(listener.getLogger(), resultsFile);
            FitnesseResultsAction action = new FitnesseResultsAction(build, results);
            if (results.getBuildResult() != null) {
                build.setResult(results.getBuildResult());
            }
            build.addAction((Action)action);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FitnesseResults getResults(PrintStream logger, FilePath resultsFile) throws IOException, TransformerException {
        InputStream resultsInputStream = null;
        try {
            logger.println("Reading results as " + Charset.defaultCharset().displayName() + " from " + resultsFile.getRemote());
            resultsInputStream = resultsFile.read();
            logger.println("Parsing results... ");
            NativePageCountsParser pageCountsParser = new NativePageCountsParser();
            NativePageCounts pageCounts = pageCountsParser.parse(resultsInputStream);
            logger.println("Got results: " + pageCounts.getSummary());
            FitnesseResults fitnesseResults = new FitnesseResults(pageCounts);
            return fitnesseResults;
        }
        finally {
            if (resultsInputStream != null) {
                try {
                    resultsInputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

