/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.fitnesse.FitnesseBuildAction;
import hudson.plugins.fitnesse.FitnesseResults;
import hudson.plugins.fitnesse.FitnesseResultsAction;
import hudson.plugins.fitnesse.NativePageCounts;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseResults
extends TestResult
implements Comparable<FitnesseResults> {
    private static final long serialVersionUID = 1L;
    private transient boolean durationCalculated;
    private transient long durationInMillis;
    private transient List<FitnesseResults> failed = null;
    private transient List<FitnesseResults> skipped = null;
    private transient List<FitnesseResults> passed = null;
    private NativePageCounts.Counts pageCounts;
    private TestObject parent;
    private List<FitnesseResults> details = new ArrayList();
    private AbstractBuild<?, ?> owner;

    public FitnesseResults(NativePageCounts.Counts pageCounts) {
        this.pageCounts = pageCounts;
    }

    FitnesseResults(NativePageCounts allCounts) {
        this(allCounts.getSummary());
        for (NativePageCounts.Counts detail : allCounts.getDetails()) {
            this.addDetail(new FitnesseResults(detail));
        }
    }

    void addDetail(FitnesseResults fitnesseResults) {
        this.details.add(fitnesseResults);
        fitnesseResults.setParent((TestObject)this);
    }

    public TestResult findCorrespondingResult(String id) {
        if (id.equals(this.getId())) {
            return this;
        }
        List match = this.filteredCopyOfDetails((ResultsFilter)new /* Unavailable Anonymous Inner Class!! */);
        return match.size() == 0 ? null : (FitnesseResults)match.get(0);
    }

    public void setOwner(AbstractBuild<?, ?> build) {
        this.owner = build;
    }

    public AbstractBuild<?, ?> getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        if (this.parent != null) {
            return this.parent.getOwner();
        }
        return null;
    }

    public void setParent(TestObject parentObject) {
        this.parent = parentObject;
    }

    public TestObject getParent() {
        return this.parent;
    }

    public String getName() {
        return this.pageCounts.page;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public int getFailCount() {
        return this.pageCounts.wrong + this.getExceptionCount();
    }

    public int getFailOnlyCount() {
        return this.pageCounts.wrong;
    }

    public int getPassCount() {
        return this.pageCounts.right;
    }

    public int getSkipCount() {
        return this.getIgnoredCount();
    }

    public int getIgnoredCount() {
        return this.pageCounts.ignored;
    }

    public int getExceptionCount() {
        return this.pageCounts.exceptions;
    }

    public boolean isFailedOverall() {
        return this.getFailCount() > 0 || this.getExceptionCount() > 0;
    }

    public boolean isPassedOverall() {
        return this.isPassed();
    }

    public boolean isPassed() {
        return !this.isFailedOverall() && !this.isSkippedOverall();
    }

    public boolean isSkippedOverall() {
        if (this.isFailedOverall()) {
            return false;
        }
        if (this.getExceptionCount() > 0) {
            return true;
        }
        return this.getPassCount() == 0;
    }

    public Result getBuildResult() {
        if (this.getFailCount() > 0) {
            return Result.FAILURE;
        }
        return null;
    }

    public float getDuration() {
        if (!this.durationCalculated) {
            this.calculateDurationInMillis();
        }
        return (float)this.durationInMillis / 1000.0f;
    }

    private void calculateDurationInMillis() {
        FitnesseResults earliest = null;
        FitnesseResults latest = null;
        for (FitnesseResults detail : this.details) {
            if (earliest == null) {
                earliest = detail;
            } else if (detail.isEarlierThan(earliest)) {
                earliest = detail;
            }
            if (latest == null) {
                latest = detail;
                continue;
            }
            if (!detail.isLaterThan(latest)) continue;
            latest = detail;
        }
        this.durationInMillis = latest.millisAfter(earliest);
        this.durationCalculated = true;
    }

    public boolean isEarlierThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().before(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isLaterThan(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().after(other.pageCounts.resultsDateAsDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public long millisAfter(FitnesseResults other) {
        try {
            return this.pageCounts.resultsDateAsDate().getTime() - other.pageCounts.resultsDateAsDate().getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String getHeadlineText() {
        return this.pageCounts.toString();
    }

    public FitnesseResultsAction getTestResultAction() {
        return this.getParentAction();
    }

    public FitnesseResultsAction getParentAction() {
        FitnesseResultsAction action = (FitnesseResultsAction)this.getOwner().getAction(FitnesseResultsAction.class);
        return action;
    }

    @Override
    public int compareTo(FitnesseResults other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    public Collection<FitnesseResults> getFailedTests() {
        if (this.failed == null) {
            this.failed = this.filteredCopyOfDetails((ResultsFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.failed;
    }

    public Collection<FitnesseResults> getPassedTests() {
        if (this.passed == null) {
            this.passed = this.filteredCopyOfDetails((ResultsFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.passed;
    }

    public Collection<FitnesseResults> getSkippedTests() {
        if (this.skipped == null) {
            this.skipped = this.filteredCopyOfDetails((ResultsFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.skipped;
    }

    private List<FitnesseResults> filteredCopyOfDetails(ResultsFilter countsFilter) {
        ArrayList<FitnesseResults> filteredCopy = new ArrayList<FitnesseResults>();
        for (FitnesseResults result : this.details) {
            if (!countsFilter.include(result)) continue;
            filteredCopy.add(result);
        }
        Collections.sort(filteredCopy);
        return filteredCopy;
    }

    public String toHtml(FitnesseResults results) {
        FitnesseBuildAction buildAction = (FitnesseBuildAction)this.getOwner().getAction(FitnesseBuildAction.class);
        if (buildAction == null) {
            buildAction = FitnesseBuildAction.NULL_ACTION;
        }
        return buildAction.getLinkFor(results.getName(), Hudson.getInstance().getRootUrl());
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.findCorrespondingResult(token);
    }
}

