/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.fitnesse.FitnesseBuildAction;
import hudson.plugins.fitnesse.FitnesseBuilder;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.plugins.fitnesse.ResetEvent;
import hudson.plugins.fitnesse.Resettable;
import hudson.plugins.fitnesse.RunnerWithTimeOut;
import hudson.plugins.fitnesse.StdConsole;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FitnesseExecutor {
    private static final int SLEEP_MILLIS = 1000;
    private static final int STARTUP_TIMEOUT_MILLIS = 10000;
    private static final int ADDITIONAL_TIMEOUT_MILLIS = 20000;
    private final FitnesseBuilder builder;

    public FitnesseExecutor(FitnesseBuilder builder) {
        this.builder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean execute(AbstractBuild<?, ?> build, Launcher launcher, PrintStream logger, EnvVars environment) throws InterruptedException {
        block6: {
            fitnesseProc = null;
            console = new StdConsole();
            build.addAction((Action)this.getFitnesseBuildAction());
            if (!this.builder.getFitnesseStart()) ** GOTO lbl15
            fitnesseProc = this.startFitnesse(build, launcher, environment, logger, console);
            if (this.procStarted(fitnesseProc, logger, console)) break block6;
            var7_7 = false;
            this.killProc(logger, fitnesseProc);
            console.logIncrementalOutput(logger);
            return var7_7;
        }
        try {
            console.logIncrementalOutput(logger);
lbl15:
            // 2 sources

            resultsFilePath = FitnesseExecutor.getResultsFilePath((FilePath)FitnesseExecutor.getWorkingDirectory(build), (String)this.builder.getFitnessePathToXmlResultsOut());
            this.readAndWriteFitnesseResults(logger, console, this.getFitnessePageCmdURL(), resultsFilePath);
            var8_10 = true;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace(logger);
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                var8_11 = false;
            }
            catch (Throwable var9_12) {
                this.killProc(logger, fitnesseProc);
                console.logIncrementalOutput(logger);
                throw var9_12;
            }
            this.killProc(logger, fitnesseProc);
            console.logIncrementalOutput(logger);
            return var8_11;
        }
        this.killProc(logger, fitnesseProc);
        console.logIncrementalOutput(logger);
        return var8_10;
    }

    private FitnesseBuildAction getFitnesseBuildAction() {
        return new FitnesseBuildAction(this.builder.getFitnesseStart(), this.builder.getFitnesseHost(), this.builder.getFitnessePort());
    }

    private Proc startFitnesse(AbstractBuild<?, ?> build, Launcher launcher, EnvVars envVars, PrintStream logger, StdConsole console) throws IOException {
        logger.println("Starting new Fitnesse instance...");
        Launcher.ProcStarter procStarter = launcher.launch().cmds((List)this.getJavaCmd(FitnesseExecutor.getWorkingDirectory(build), envVars));
        procStarter.pwd(new File(FitnesseExecutor.getAbsolutePathToFileThatMayBeRelativeToWorkspace((FilePath)FitnesseExecutor.getWorkingDirectory(build), (String)this.builder.getFitnesseJavaWorkingDirectory())));
        console.provideStdOutAndStdErrFor(procStarter);
        return procStarter.start();
    }

    public ArrayList<String> getJavaCmd(FilePath workingDirectory, EnvVars envVars) {
        String fitnesseJavaOpts;
        String java = "java";
        if (envVars.containsKey((Object)"JAVA_HOME")) {
            java = new File(new File((String)envVars.get((Object)"JAVA_HOME"), "bin"), java).getAbsolutePath();
        }
        String[] java_opts = "".equals(fitnesseJavaOpts = this.builder.getFitnesseJavaOpts()) ? new String[]{} : fitnesseJavaOpts.split(" ");
        String absolutePathToFitnesseJar = FitnesseExecutor.getAbsolutePathToFileThatMayBeRelativeToWorkspace((FilePath)workingDirectory, (String)this.builder.getFitnessePathToJar());
        String[] jar_opts = new String[]{"-jar", absolutePathToFitnesseJar};
        File fitNesseRoot = new File(FitnesseExecutor.getAbsolutePathToFileThatMayBeRelativeToWorkspace((FilePath)workingDirectory, (String)this.builder.getFitnessePathToRoot()));
        String[] fitnesse_opts = new String[]{"-d", fitNesseRoot.getParent(), "-r", fitNesseRoot.getName(), "-p", Integer.toString(this.builder.getFitnessePort())};
        String[] addOps = FitnesseExecutor.splitOptions((String)this.builder.getAdditionalFitnesseOptions());
        String[] fitnesse_opts2 = new String[fitnesse_opts.length + addOps.length];
        System.arraycopy(fitnesse_opts, 0, fitnesse_opts2, 0, fitnesse_opts.length);
        System.arraycopy(addOps, 0, fitnesse_opts2, fitnesse_opts.length, addOps.length);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java);
        if (java_opts.length > 0) {
            cmd.addAll(Arrays.asList(java_opts));
        }
        cmd.addAll(Arrays.asList(jar_opts));
        cmd.addAll(Arrays.asList(fitnesse_opts2));
        return cmd;
    }

    private static String[] splitOptions(String string) {
        ArrayList<String> addOps = new ArrayList<String>();
        Pattern pattern = Pattern.compile("-{1}[a-z]{1}\\s?[^-]*");
        Matcher m = pattern.matcher(string);
        while (m.find()) {
            String s = m.group();
            addOps.add(s.substring(0, 2).trim());
            addOps.add(s.substring(2, s.length()).trim());
        }
        String[] ret = new String[addOps.size()];
        return addOps.toArray(ret);
    }

    private boolean procStarted(Proc fitnesseProc, PrintStream log, StdConsole console) throws IOException, InterruptedException {
        if (fitnesseProc.isAlive()) {
            return this.fitnesseStarted(log, console, 10000L);
        }
        return false;
    }

    public boolean fitnesseStarted(PrintStream log, StdConsole console, long timeout) throws InterruptedException {
        long waitedAlready = 0L;
        do {
            Thread.sleep(1000L);
            if (console.noIncrementalOutput()) {
                waitedAlready += 1000L;
                continue;
            }
            if (console.incrementalOutputOnStdErr()) {
                timeout += 20000L;
            }
            console.logIncrementalOutput(log);
        } while (waitedAlready < timeout);
        if (console.noOutputOnStdOut()) {
            log.println("Waited " + waitedAlready + "ms for fitnesse to start.");
            return false;
        }
        return true;
    }

    private void killProc(PrintStream log, Proc proc) {
        if (proc != null) {
            try {
                proc.kill();
                for (int i = 0; i < 4; ++i) {
                    if (!proc.isAlive()) continue;
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace(log);
            }
        }
    }

    private void readAndWriteFitnesseResults(PrintStream logger, StdConsole console, URL readFromURL, FilePath writeToFilePath) throws InterruptedException {
        RunnerWithTimeOut runnerWithTimeOut = new RunnerWithTimeOut(this.builder.getFitnesseHttpTimeout());
        1 readAndWriteResults = new /* Unavailable Anonymous Inner Class!! */;
        2 logToConsole = new /* Unavailable Anonymous Inner Class!! */;
        runnerWithTimeOut.run((Runnable)readAndWriteResults, (ResetEvent)logToConsole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHttpBytes(PrintStream log, URL pageCmdTarget, Resettable timeout) {
        InputStream inputStream = null;
        ByteArrayOutputStream bucket = new ByteArrayOutputStream();
        try {
            int lastRead;
            log.println("Connnecting to " + pageCmdTarget);
            HttpURLConnection connection = (HttpURLConnection)pageCmdTarget.openConnection();
            log.println("Connected: " + connection.getResponseCode() + "/" + connection.getResponseMessage());
            inputStream = connection.getInputStream();
            long recvd = 0L;
            long lastLogged = 0L;
            byte[] buf = new byte[4096];
            while ((lastRead = inputStream.read(buf)) > 0) {
                bucket.write(buf, 0, lastRead);
                timeout.reset();
                if ((recvd += (long)lastRead) - lastLogged <= 1024L) continue;
                log.println(recvd / 1024L + "k...");
                lastLogged = recvd;
            }
        }
        catch (IOException e) {
            e.printStackTrace(log);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return bucket.toByteArray();
    }

    public URL getFitnessePageCmdURL() throws MalformedURLException {
        return new URL("http", this.builder.getFitnesseHost(), this.builder.getFitnessePort(), this.getFitnessePageCmd());
    }

    public String getFitnessePageCmd() {
        String targetPageExpression = this.builder.getFitnesseTargetPage();
        if (targetPageExpression.contains("?")) {
            return "/" + targetPageExpression + "&format=xml";
        }
        int pos = targetPageExpression.indexOf(38);
        if (pos == -1) {
            pos = targetPageExpression.length();
        }
        return String.format("/%1$s?%2$s%3$s", targetPageExpression.substring(0, pos), this.builder.getFitnesseTargetIsSuite() ? "suite" : "test", targetPageExpression.substring(pos) + "&format=xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFitnesseResults(PrintStream log, FilePath resultsFilePath, byte[] results) {
        OutputStream resultsStream = null;
        try {
            resultsStream = resultsFilePath.write();
            resultsStream.write(results);
            log.println("Xml results saved as " + Charset.defaultCharset().displayName() + " to " + resultsFilePath.getRemote());
        }
        catch (IOException e) {
            e.printStackTrace(log);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace(log);
        }
        finally {
            try {
                if (resultsStream != null) {
                    resultsStream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    static FilePath getWorkingDirectory(AbstractBuild<?, ?> build) {
        FilePath workspace = build.getWorkspace();
        if (workspace != null) {
            return workspace;
        }
        return new FilePath(build.getRootDir());
    }

    static FilePath getResultsFilePath(FilePath workingDirectory, String fileName) {
        File fileNameFile = new File(fileName);
        if (fileNameFile.getParent() != null && (fileNameFile.exists() || fileNameFile.getParentFile().exists())) {
            return new FilePath(fileNameFile);
        }
        return workingDirectory.child(fileName);
    }

    static String getAbsolutePathToFileThatMayBeRelativeToWorkspace(FilePath workingDirectory, String fileName) {
        if (new File(fileName).exists()) {
            return fileName;
        }
        return new File(workingDirectory.getRemote(), fileName).getAbsolutePath();
    }

    static /* synthetic */ void access$000(FitnesseExecutor x0, PrintStream x1, FilePath x2, byte[] x3) {
        x0.writeFitnesseResults(x1, x2, x3);
    }
}

