/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.fitnesse.FitnesseBuilder;
import hudson.plugins.fitnesse.FitnesseExecutor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitnesseBuilder
extends Builder {
    public static final String START_FITNESSE = "fitnesseStart";
    public static final String FITNESSE_HOST = "fitnesseHost";
    public static final String FITNESSE_PORT = "fitnessePort";
    public static final String FITNESSE_PORT_REMOTE = "fitnessePortRemote";
    public static final String FITNESSE_PORT_LOCAL = "fitnessePortLocal";
    public static final String FITNESSE_ADDITIONAL_OPTIONS = "additionalFitnesseOptions";
    public static final String JAVA_OPTS = "fitnesseJavaOpts";
    public static final String PATH_TO_JAR = "fitnessePathToJar";
    public static final String PATH_TO_ROOT = "fitnessePathToRoot";
    public static final String TARGET_PAGE = "fitnesseTargetPage";
    public static final String TARGET_IS_SUITE = "fitnesseTargetIsSuite";
    public static final String PATH_TO_RESULTS = "fitnessePathToXmlResultsOut";
    public static final String HTTP_TIMEOUT = "fitnesseHttpTimeout";
    public static final String JAVA_WORKING_DIRECTORY = "fitnesseJavaWorkingDirectory";
    static final int _URL_READ_TIMEOUT_MILLIS = 60000;
    static final String _LOCALHOST = "localhost";
    private Map<String, String> options;

    @DataBoundConstructor
    public FitnesseBuilder(Map<String, String> options) {
        this.options = options;
    }

    private String getOption(String key, String valueIfKeyNotFound) {
        String value;
        if (this.options.containsKey(key) && (value = (String)this.options.get(key)) != null && !"".equals(value)) {
            return value;
        }
        return valueIfKeyNotFound;
    }

    public boolean getFitnesseStart() {
        return Boolean.parseBoolean(this.getOption(START_FITNESSE, "False"));
    }

    public String getFitnesseHost() {
        if (this.getFitnesseStart()) {
            return _LOCALHOST;
        }
        return this.getOption(FITNESSE_HOST, "unknown_host");
    }

    public String getFitnesseJavaOpts() {
        return this.getOption(JAVA_OPTS, "");
    }

    public String getFitnesseJavaWorkingDirectory() {
        String fitnessePathToJar = this.getFitnessePathToJar();
        String fitnesseJarDir = "";
        if (!"".equals(fitnessePathToJar)) {
            File jarFile = new File(fitnessePathToJar);
            if (jarFile.exists()) {
                fitnesseJarDir = jarFile.getParentFile().getAbsolutePath();
            } else {
                fitnesseJarDir = jarFile.getParent();
                if (fitnesseJarDir == null) {
                    fitnesseJarDir = "";
                }
            }
        }
        return this.getOption(JAVA_WORKING_DIRECTORY, fitnesseJarDir);
    }

    public int getFitnessePort() {
        return Integer.parseInt(this.getOption(FITNESSE_PORT_REMOTE, this.getOption(FITNESSE_PORT_LOCAL, this.getOption(FITNESSE_PORT, "-1"))));
    }

    public String getFitnessePathToJar() {
        return this.getOption(PATH_TO_JAR, "fitnesse.jar");
    }

    public String getAdditionalFitnesseOptions() {
        String sanitizedOptions = this.getOption(FITNESSE_ADDITIONAL_OPTIONS, "");
        if (sanitizedOptions.length() > 2 && sanitizedOptions.startsWith("\"") && sanitizedOptions.endsWith("\"")) {
            sanitizedOptions = sanitizedOptions.substring(1, sanitizedOptions.length() - 1);
        }
        return sanitizedOptions;
    }

    public String getFitnessePathToRoot() {
        return this.getOption(PATH_TO_ROOT, "FitNesseRoot");
    }

    public String getFitnesseTargetPage() {
        return this.getOption(TARGET_PAGE, "");
    }

    public boolean getFitnesseTargetIsSuite() {
        return Boolean.parseBoolean(this.getOption(TARGET_IS_SUITE, "False"));
    }

    public String getFitnessePathToXmlResultsOut() {
        return this.getOption(PATH_TO_RESULTS, "fitnesse-results.xml");
    }

    public int getFitnesseHttpTimeout() {
        return Integer.parseInt(this.getOption(HTTP_TIMEOUT, String.valueOf(60000)));
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        logger.println(this.getClass().getName() + ": " + this.options);
        FitnesseExecutor fitnesseExecutor = new FitnesseExecutor(this);
        return fitnesseExecutor.execute(build, launcher, logger, build.getEnvironment((TaskListener)listener));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

