/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.fitnesse;

import hudson.model.Action;
import hudson.model.InvisibleAction;
import java.net.MalformedURLException;
import java.net.URL;

public class FitnesseBuildAction
extends InvisibleAction
implements Action {
    public static final FitnesseBuildAction NULL_ACTION = new FitnesseBuildAction(true, null, 0);
    private final String fitnesseHost;
    private final int fitnessePort;
    private final boolean fitnesseStarted;

    public FitnesseBuildAction(boolean fitnesseStarted, String fitnesseHost, int fitnessePort) {
        this.fitnesseStarted = fitnesseStarted;
        this.fitnesseHost = fitnesseHost;
        this.fitnessePort = fitnessePort;
    }

    public String getLinkFor(String fitnessePage) {
        return this.getLinkFor(fitnessePage, null);
    }

    public String getLinkFor(String fitnessePage, String hudsonHost) {
        if (this.fitnesseStarted) {
            return fitnessePage;
        }
        String host = this.fitnesseHost;
        if (hudsonHost != null && "localhost".equals(this.fitnesseHost)) {
            try {
                host = new URL(hudsonHost).getHost();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return String.format("<a href=\"http://%s:%s/%s\">%s</a>", host, this.fitnessePort, fitnessePage, fitnessePage);
    }
}

