// CHECKSTYLE:OFF

package org.jenkinsci.plugins.envinject;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code EnvInjectPasswordWrapper.DisplayName}: {@code Inject
     * passwords to the build as environment variables}.
     * 
     * @return
     *     {@code Inject passwords to the build as environment variables}
     */
    public static String EnvInjectPasswordWrapper_DisplayName() {
        return holder.format("EnvInjectPasswordWrapper.DisplayName");
    }

    /**
     * Key {@code EnvInjectPasswordWrapper.DisplayName}: {@code Inject
     * passwords to the build as environment variables}.
     * 
     * @return
     *     {@code Inject passwords to the build as environment variables}
     */
    public static Localizable _EnvInjectPasswordWrapper_DisplayName() {
        return new Localizable(holder, "EnvInjectPasswordWrapper.DisplayName");
    }

    /**
     * Key {@code envinject.wrapper.displayName}: {@code Inject environment
     * variables to the build process}.
     * 
     * @return
     *     {@code Inject environment variables to the build process}
     */
    public static String envinject_wrapper_displayName() {
        return holder.format("envinject.wrapper.displayName");
    }

    /**
     * Key {@code envinject.wrapper.displayName}: {@code Inject environment
     * variables to the build process}.
     * 
     * @return
     *     {@code Inject environment variables to the build process}
     */
    public static Localizable _envinject_wrapper_displayName() {
        return new Localizable(holder, "envinject.wrapper.displayName");
    }

    /**
     * Key {@code envinject.set.displayName}: {@code Setup a build
     * environment}.
     * 
     * @return
     *     {@code Setup a build environment}
     */
    public static String envinject_set_displayName() {
        return holder.format("envinject.set.displayName");
    }

    /**
     * Key {@code envinject.set.displayName}: {@code Setup a build
     * environment}.
     * 
     * @return
     *     {@code Setup a build environment}
     */
    public static Localizable _envinject_set_displayName() {
        return new Localizable(holder, "envinject.set.displayName");
    }

    /**
     * Key {@code envinject.permissions.viewVars.description}: {@code View
     * injected environment variables}.
     * 
     * @return
     *     {@code View injected environment variables}
     */
    public static String envinject_permissions_viewVars_description() {
        return holder.format("envinject.permissions.viewVars.description");
    }

    /**
     * Key {@code envinject.permissions.viewVars.description}: {@code View
     * injected environment variables}.
     * 
     * @return
     *     {@code View injected environment variables}
     */
    public static Localizable _envinject_permissions_viewVars_description() {
        return new Localizable(holder, "envinject.permissions.viewVars.description");
    }

    /**
     * Key {@code envinject.addVars.displayName}: {@code Inject environment
     * variables}.
     * 
     * @return
     *     {@code Inject environment variables}
     */
    public static String envinject_addVars_displayName() {
        return holder.format("envinject.addVars.displayName");
    }

    /**
     * Key {@code envinject.addVars.displayName}: {@code Inject environment
     * variables}.
     * 
     * @return
     *     {@code Inject environment variables}
     */
    public static Localizable _envinject_addVars_displayName() {
        return new Localizable(holder, "envinject.addVars.displayName");
    }

    /**
     * Key {@code envinject.nodeProperty.displayName}: {@code Prepare jobs
     * environment}.
     * 
     * @return
     *     {@code Prepare jobs environment}
     */
    public static String envinject_nodeProperty_displayName() {
        return holder.format("envinject.nodeProperty.displayName");
    }

    /**
     * Key {@code envinject.nodeProperty.displayName}: {@code Prepare jobs
     * environment}.
     * 
     * @return
     *     {@code Prepare jobs environment}
     */
    public static Localizable _envinject_nodeProperty_displayName() {
        return new Localizable(holder, "envinject.nodeProperty.displayName");
    }

    /**
     * Key {@code envinject.permissions.title}: {@code Env. Inject}.
     * 
     * @return
     *     {@code Env. Inject}
     */
    public static String envinject_permissions_title() {
        return holder.format("envinject.permissions.title");
    }

    /**
     * Key {@code envinject.permissions.title}: {@code Env. Inject}.
     * 
     * @return
     *     {@code Env. Inject}
     */
    public static Localizable _envinject_permissions_title() {
        return new Localizable(holder, "envinject.permissions.title");
    }

}
