/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.BuildCauseRetriever;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVarsUnset;
import org.jenkinsci.plugins.envinject.service.EnvInjectScriptExecutorService;
import org.jenkinsci.plugins.envinject.service.PropertiesVariablesRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class EnvInjectListener
extends RunListener<Run>
implements Serializable {
    private static Logger LOG = Logger.getLogger(EnvInjectListener.class.getName());

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        if (this.isEnvInjectJobPropertyActive((Run)build)) {
            try {
                FilePath rootPath;
                LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
                EnvInjectJobProperty envInjectJobProperty = this.getEnvInjectJobProperty((Run)build);
                assert (envInjectJobProperty != null);
                EnvInjectJobPropertyInfo info = envInjectJobProperty.getInfo();
                assert (envInjectJobProperty != null && envInjectJobProperty.isOn());
                if (envInjectJobProperty.isKeepJenkinsSystemVariables()) {
                    variables.putAll((Map<String, String>)build.getEnvironment((TaskListener)new LogTaskListener(LOG, Level.ALL)));
                }
                if (envInjectJobProperty.isKeepBuildVariables()) {
                    variables.putAll(this.getBuildVariables(build));
                }
                if ((rootPath = this.getNodeRootPath()) != null) {
                    Map<String, String> envMap = this.getEnvVarsFromProperties(rootPath, info, variables, launcher, listener);
                    variables.putAll(envMap);
                    if (info.isPopulateTriggerCause()) {
                        Map<String, String> triggerVariable = new BuildCauseRetriever().getTriggeredCause(build);
                        variables.putAll(triggerVariable);
                    }
                    EnvVars.resolve(variables);
                    final Map<String, String> resultVariables = new EnvInjectEnvVarsUnset(logger).removeUnsetVars(variables);
                    new EnvInjectActionSetter(rootPath).addEnvVarsToEnvInjectBuildAction(build, resultVariables);
                    EnvInjectListener.executeScript(rootPath, info, resultVariables, launcher, listener);
                    return new Environment(){

                        public void buildEnvVars(Map<String, String> env) {
                            env.putAll(resultVariables);
                        }
                    };
                }
            }
            catch (EnvInjectException envEx) {
                logger.error("SEVERE ERROR occurs: " + envEx.getMessage());
                throw new Run.RunnerAbortedException();
            }
            catch (Throwable throwable) {
                logger.error("SEVERE ERROR occurs: " + throwable.getMessage());
                throw new Run.RunnerAbortedException();
            }
        }
        return new Environment(){};
    }

    private Map<String, String> getEnvVarsFromProperties(FilePath rootPath, EnvInjectJobPropertyInfo info, Map<String, String> currentEnvVars, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        resultMap.putAll((Map)rootPath.act((FilePath.FileCallable)new PropertiesVariablesRetriever(info, currentEnvVars, logger)));
        return resultMap;
    }

    private static void executeScript(FilePath rootPath, EnvInjectJobPropertyInfo info, Map<String, String> currentEnvVars, Launcher launcher, BuildListener listener) throws EnvInjectException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        EnvInjectScriptExecutorService scriptExecutorService = new EnvInjectScriptExecutorService(info, currentEnvVars, rootPath, launcher, logger);
        scriptExecutorService.executeScriptFromInfoObject();
    }

    private Node getNode() {
        Computer computer = Computer.currentComputer();
        return computer.getNode();
    }

    private FilePath getNodeRootPath() {
        Node node = this.getNode();
        if (node != null) {
            return node.getRootPath();
        }
        return null;
    }

    private Map<String, String> getBuildVariables(AbstractBuild build) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll((Map<String, String>)build.getCharacteristicEnvVars());
        result.putAll(build.getBuildVariables());
        FilePath ws = build.getWorkspace();
        if (ws != null) {
            result.put("WORKSPACE", ws.getRemote());
        }
        return result;
    }

    private boolean isEnvInjectJobPropertyActive(Run run) {
        EnvInjectJobPropertyInfo info;
        EnvInjectJobProperty envInjectJobProperty = this.getEnvInjectJobProperty(run);
        return envInjectJobProperty != null && (info = envInjectJobProperty.getInfo()) != null && envInjectJobProperty.isOn();
    }

    private EnvInjectJobProperty getEnvInjectJobProperty(Run run) {
        return (EnvInjectJobProperty)run.getParent().getProperty(EnvInjectJobProperty.class);
    }
}

