/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.jenkinsci.plugins.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectNodeProperty;
import org.jenkinsci.plugins.envinject.service.EnvInjectMasterEnvVarsSetter;

@Extension
public class EnvInjectComputerListener
extends ComputerListener
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectComputerListener.class.getName());

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        boolean unsetSystemVariables = false;
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
            EnvInjectNodeProperty envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
            unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
        }
        Node slave = Hudson.getInstance().getNode(c.getName());
        if (slave != null) {
            for (NodeProperty nodeProperty : c.getNode().getNodeProperties()) {
                if (!(nodeProperty instanceof EnvInjectNodeProperty)) continue;
                EnvInjectNodeProperty envInjectNodeProperty = (EnvInjectNodeProperty)nodeProperty;
                unsetSystemVariables = envInjectNodeProperty.isUnsetSystemVariables();
            }
        }
        if (unsetSystemVariables) {
            try {
                c.getNode().getRootPath().act((Callable)new EnvInjectMasterEnvVarsSetter(new EnvVars()));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
        }
    }
}

