/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class CauseHelper {
    private static final int MAX_UPSTREAM_DEPTH = 10;
    public static final String ENV_CAUSE = "BUILD_CAUSE";
    public static final String ENV_ROOT_CAUSE = "ROOT_BUILD_CAUSE";

    CauseHelper() {
    }

    static void insertRootCauseNames(@NonNull Set<String> causeNamesTarget, @CheckForNull Cause cause, int depth) {
        if (cause instanceof Cause.UpstreamCause) {
            if (depth == 10) {
                causeNamesTarget.add("DEEPLYNESTEDCAUSES");
            } else {
                Cause.UpstreamCause c = (Cause.UpstreamCause)cause;
                List upstreamCauses = c.getUpstreamCauses();
                for (Cause upstreamCause : upstreamCauses) {
                    CauseHelper.insertRootCauseNames(causeNamesTarget, upstreamCause, depth + 1);
                }
            }
        } else {
            causeNamesTarget.add(CauseHelper.getTriggerName(cause));
        }
    }

    @NonNull
    static Map<String, String> buildCauseEnvironmentVariables(@NonNull String envBase, @NonNull Collection<String> causeNames) {
        HashMap<String, String> triggerVars = new HashMap<String, String>();
        ArrayList<String> nonEmptyNames = new ArrayList<String>();
        for (String name : causeNames) {
            if (name == null || name.isEmpty()) continue;
            triggerVars.put(String.join((CharSequence)"_", envBase, name), "true");
            nonEmptyNames.add(name);
        }
        triggerVars.put(envBase, String.join((CharSequence)",", nonEmptyNames));
        return triggerVars;
    }

    @CheckForNull
    static String getTriggerName(Cause cause) {
        if (SCMTrigger.SCMTriggerCause.class.isInstance(cause)) {
            return "SCMTRIGGER";
        }
        if (TimerTrigger.TimerTriggerCause.class.isInstance(cause)) {
            return "TIMERTRIGGER";
        }
        if (Cause.UserIdCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UserCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UpstreamCause.class.isInstance(cause)) {
            return "UPSTREAMTRIGGER";
        }
        if (cause != null) {
            return cause.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
        }
        return null;
    }
}

