/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jenkinsci.lib.envinject.EnvInjectException;

public class EnvInjectVarsIO {
    private static final String ENVINJECT_TXT_FILENAME = "injectedEnvVars.txt";
    private static final String TOKEN = "=";

    private EnvInjectVarsIO() {
    }

    @CheckForNull
    public static Map<String, String> getEnvironment(@NonNull File envInjectBaseDir) throws EnvInjectException {
        HashMap<String, String> hashMap;
        block9: {
            File f = new File(envInjectBaseDir, ENVINJECT_TXT_FILENAME);
            if (!f.exists()) {
                return null;
            }
            BufferedReader fileReader = Files.newBufferedReader(f.toPath(), Charset.defaultCharset());
            try {
                HashMap<String, String> result = new HashMap<String, String>();
                EnvInjectVarsIO.fromTxt(fileReader, result);
                hashMap = result;
                if (fileReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileReader != null) {
                        try {
                            ((Reader)fileReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPathException fne) {
                    throw new EnvInjectException((Throwable)fne);
                }
            }
            ((Reader)fileReader).close();
        }
        return hashMap;
    }

    public static void saveEnvironment(@NonNull File rootDir, @NonNull Map<String, String> envMap) throws EnvInjectException {
        File f = new File(rootDir, ENVINJECT_TXT_FILENAME);
        try (BufferedWriter wr = Files.newBufferedWriter(f.toPath(), Charset.defaultCharset(), new OpenOption[0]);){
            TreeMap<String, String> map2Write = new TreeMap<String, String>(envMap);
            EnvInjectVarsIO.toTxt(map2Write, wr);
        }
        catch (IOException | InvalidPathException ex) {
            throw new EnvInjectException((Throwable)ex);
        }
    }

    private static void fromTxt(@NonNull Reader reader, @NonNull Map<String, String> result) throws EnvInjectException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKEN);
                int tokens = tokenizer.countTokens();
                if (tokens != 2) continue;
                result.put(String.valueOf(tokenizer.nextElement()), String.valueOf(tokenizer.nextElement()));
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
    }

    private static void toTxt(@NonNull Map<String, String> envMap, @NonNull Writer fw) throws IOException {
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            fw.write(entry.getKey());
            fw.write(TOKEN);
            fw.write(entry.getValue());
            fw.write(System.lineSeparator());
        }
    }
}

