/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import hudson.model.BallColor;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.badge.StatusImage;

public class ImageResolver {
    private static final Map<String, String> STATUSES = Map.of("red", "failing", "brightgreen", "passing", "yellow", "unstable", "aborted", "aborted", "blue", "running", "disabled", "disabled", "notbuilt", "not run");

    public StatusImage getImage(BallColor color, String style, String subject, String status, String colorName, String animatedOverlayColor, String link) {
        String[] styleParts;
        String statusColorName = color.noAnime().toString();
        String statusAnimatedOverlayColorName = null;
        if (style != null && (styleParts = style.split("-")).length == 2 && "ball".equals(styleParts[0])) {
            String url = color.getImageOf(styleParts[1]);
            if (url == null) {
                url = color.getImageOf("32x32");
            }
            if (url != null) {
                try {
                    return new StatusImage(url);
                }
                catch (IOException ioe) {
                    return new StatusImage();
                }
            }
        }
        if (color.isAnimated() && colorName == null) {
            statusAnimatedOverlayColorName = "blue";
        }
        if ("blue".equals(statusColorName)) {
            statusColorName = "brightgreen";
        }
        if (colorName == null) {
            colorName = "aborted".equals(statusColorName) || "disabled".equals(statusColorName) || "notbuilt".equals(statusColorName) ? "lightgrey" : statusColorName;
            if (animatedOverlayColor == null) {
                animatedOverlayColor = statusAnimatedOverlayColorName;
            }
        }
        if (subject == null) {
            subject = "build";
        }
        if (status == null && (status = STATUSES.get(statusAnimatedOverlayColorName != null ? statusAnimatedOverlayColorName : statusColorName)) == null) {
            status = "unknown";
        }
        try {
            return new StatusImage(subject, status, colorName, animatedOverlayColor, style, link);
        }
        catch (IOException ioe) {
            return new StatusImage();
        }
    }
}

