/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.ArrayUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.DependencyCheckToolBuilder;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DetectionFailedException;
import org.jenkinsci.plugins.DependencyCheck.tools.Platform;
import org.kohsuke.stapler.DataBoundConstructor;

public class DependencyCheckInstallation
extends ToolInstallation
implements EnvironmentSpecific<DependencyCheckInstallation>,
NodeSpecific<DependencyCheckInstallation> {
    private static final long serialVersionUID = 6948241591210479899L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="calculate at runtime, its value depends on the OS where it run")
    private transient Platform platform;

    @DataBoundConstructor
    public DependencyCheckInstallation(@NonNull String name, @NonNull String home, List<? extends ToolProperty<?>> properties) {
        this(name, home, properties, null);
    }

    protected DependencyCheckInstallation(@NonNull String name, @Nullable String home, List<? extends ToolProperty<?>> properties, Platform platform) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
        this.platform = platform;
    }

    public DependencyCheckInstallation forEnvironment(EnvVars environment) {
        return new DependencyCheckInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public DependencyCheckInstallation forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new DependencyCheckInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList(), Platform.of(node));
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("PATH+OWASP", this.getBin());
    }

    private String getBin() {
        Platform currentPlatform = null;
        try {
            currentPlatform = this.getPlatform();
        }
        catch (DetectionFailedException e) {
            throw new RuntimeException(e);
        }
        return DependencyCheckInstallation.getBin(currentPlatform, this.getHome());
    }

    private static String getBin(Platform currentPlatform, String home) {
        Object bin = home;
        switch (currentPlatform) {
            case WINDOWS: {
                bin = (String)bin + "\\bin";
                break;
            }
            default: {
                bin = (String)bin + "/bin";
            }
        }
        return bin;
    }

    private Platform getPlatform() throws DetectionFailedException {
        Platform currentPlatform = this.platform;
        if (currentPlatform == null) {
            Computer computer = Computer.currentComputer();
            if (computer != null) {
                Node node = computer.getNode();
                if (node == null) {
                    throw new DetectionFailedException(Messages.Builder_nodeOffline());
                }
                currentPlatform = Platform.of(node);
            } else {
                currentPlatform = Platform.current();
            }
            this.platform = currentPlatform;
        }
        return currentPlatform;
    }

    public String getExecutable(@NonNull Launcher launcher) throws IOException, InterruptedException {
        VirtualChannel channel = launcher.getChannel();
        if (channel == null) {
            throw new IOException("Unable to get a channel for the launcher");
        }
        return (String)channel.call((Callable)new FindExecutableCallable(this.getHome()));
    }

    private static class FindExecutableCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final String CMD = "dependency-check";
        private final String home;

        FindExecutableCallable(String home) {
            this.home = home;
        }

        public String call() throws IOException {
            Platform currentPlatform = Platform.current();
            File exe = new File(DependencyCheckInstallation.getBin(currentPlatform, this.home), CMD + currentPlatform.cmdExtension);
            if (exe.exists()) {
                return exe.getPath();
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"dependency-check"})
    public static class DescriptorImpl
    extends ToolDescriptor<DependencyCheckInstallation> {
        public DescriptorImpl() {
            this.load();
            if (ArrayUtils.isEmpty((Object[])this.getInstallations())) {
                this.migrate();
            }
        }

        private void migrate() {
            DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor oldDescriptor = new DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor();
            DependencyCheckInstallation[] installations = oldDescriptor.loadInstalltions();
            if (!ArrayUtils.isEmpty((Object[])installations)) {
                this.setInstallations(installations);
                oldDescriptor.purge();
            }
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Installation_displayName();
        }

        public void setInstallations(DependencyCheckInstallation ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }
    }
}

