/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.util.AbstractXmlStream;
import io.jenkins.plugins.util.BuildAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.jenkinsci.plugins.DependencyCheck.JobAction;
import org.jenkinsci.plugins.DependencyCheck.action.ResultProjectAction;
import org.jenkinsci.plugins.DependencyCheck.charts.DependencyCheckBuildResult;
import org.jenkinsci.plugins.DependencyCheck.charts.DependencyCheckBuildResultXmlStream;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyCheck.transformer.FindingsTransformer;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ResultAction
extends BuildAction<DependencyCheckBuildResult> {
    private static final long serialVersionUID = -6533677178186658819L;

    public ResultAction(Run<?, ?> owner, List<Finding> findings, SeverityDistribution severityDistribution) {
        super(owner, (Object)new DependencyCheckBuildResult(findings, severityDistribution));
    }

    public String getIconFileName() {
        return "/plugin/dependency-check-jenkins-plugin/icons/dependency-check-icon.svg";
    }

    public String getDisplayName() {
        return "Dependency-Check";
    }

    public String getUrlName() {
        return "dependency-check-findings";
    }

    protected AbstractXmlStream<DependencyCheckBuildResult> createXmlStream() {
        return new DependencyCheckBuildResultXmlStream();
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<ResultProjectAction> prjActions = new ArrayList<ResultProjectAction>(2);
        prjActions.addAll(super.getProjectActions());
        prjActions.add(new ResultProjectAction(this.getOwner().getParent()));
        return Collections.unmodifiableCollection(prjActions);
    }

    protected io.jenkins.plugins.util.JobAction<? extends BuildAction<DependencyCheckBuildResult>> createProjectAction() {
        return new JobAction(this.getOwner().getParent());
    }

    protected String getBuildResultBaseName() {
        return "vulnerabilityReport.xml";
    }

    public SeverityDistribution getSeverityDistribution() {
        return ((DependencyCheckBuildResult)this.getResult()).getSeverityDistribution();
    }

    public List<Finding> getFindings() {
        return ((DependencyCheckBuildResult)this.getResult()).getFindings();
    }

    @JavaScriptMethod
    public JSONObject getFindingsJson() {
        FindingsTransformer transformer = new FindingsTransformer();
        return transformer.transform(this.getFindings());
    }

    @JavaScriptMethod
    public JSONObject getSeverityDistributionJson() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setExcludes(new String[]{"buildNumber"});
        return JSONObject.fromObject((Object)this.getSeverityDistribution(), (JsonConfig)jsonConfig);
    }
}

