// CHECKSTYLE:OFF

package org.jenkinsci.plugins.DependencyCheck;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Publisher.NoArtifactsFound}: {@code Unable to find

     * Dependency-Check reports to parse}.
     * 
     * @return
     *     {@code Unable to find Dependency-Check reports to parse}
     */
    public static String Publisher_NoArtifactsFound() {
        return holder.format("Publisher.NoArtifactsFound");
    }

    /**
     * Key {@code Publisher.NoArtifactsFound}: {@code Unable to find

     * Dependency-Check reports to parse}.
     * 
     * @return
     *     {@code Unable to find Dependency-Check reports to parse}
     */
    public static Localizable _Publisher_NoArtifactsFound() {
        return new Localizable(holder, "Publisher.NoArtifactsFound");
    }

    /**
     * Key {@code Installer.installFromCache}: {@code Installing dependency

     * check from {0} to {1} on {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing dependency check from {0} to {1} on {2}}
     */
    public static String Installer_installFromCache(Object arg0, Object arg1, Object arg2) {
        return holder.format("Installer.installFromCache", arg0, arg1, arg2);
    }

    /**
     * Key {@code Installer.installFromCache}: {@code Installing dependency

     * check from {0} to {1} on {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Installing dependency check from {0} to {1} on {2}}
     */
    public static Localizable _Installer_installFromCache(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "Installer.installFromCache", arg0, arg1, arg2);
    }

    /**
     * Key {@code Publisher.CollectingArtifact}: {@code Collecting

     * Dependency-Check artifact}.
     * 
     * @return
     *     {@code Collecting Dependency-Check artifact}
     */
    public static String Publisher_CollectingArtifact() {
        return holder.format("Publisher.CollectingArtifact");
    }

    /**
     * Key {@code Publisher.CollectingArtifact}: {@code Collecting

     * Dependency-Check artifact}.
     * 
     * @return
     *     {@code Collecting Dependency-Check artifact}
     */
    public static Localizable _Publisher_CollectingArtifact() {
        return new Localizable(holder, "Publisher.CollectingArtifact");
    }

    /**
     * Key {@code Builder.DescriptorImpl.invalidCredentialsId}: {@code

     * Current credentials does not exists}.
     * 
     * @return
     *     {@code Current credentials does not exists}
     */
    public static String Builder_DescriptorImpl_invalidCredentialsId() {
        return holder.format("Builder.DescriptorImpl.invalidCredentialsId");
    }

    /**
     * Key {@code Builder.DescriptorImpl.invalidCredentialsId}: {@code

     * Current credentials does not exists}.
     * 
     * @return
     *     {@code Current credentials does not exists}
     */
    public static Localizable _Builder_DescriptorImpl_invalidCredentialsId() {
        return new Localizable(holder, "Builder.DescriptorImpl.invalidCredentialsId");
    }

    /**
     * Key {@code Installer.invalidMD5Cache}: {@code Discarded cached archive

     * {0} because does not match stored MD5}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discarded cached archive {0} because does not match stored MD5}
     */
    public static String Installer_invalidMD5Cache(Object arg0) {
        return holder.format("Installer.invalidMD5Cache", arg0);
    }

    /**
     * Key {@code Installer.invalidMD5Cache}: {@code Discarded cached archive

     * {0} because does not match stored MD5}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discarded cached archive {0} because does not match stored MD5}
     */
    public static Localizable _Installer_invalidMD5Cache(Object arg0) {
        return new Localizable(holder, "Installer.invalidMD5Cache", arg0);
    }

    /**
     * Key {@code Builder.DescriptorImpl.emptyCredentialsId}: {@code

     * Credentials is required}.
     * 
     * @return
     *     {@code Credentials is required}
     */
    public static String Builder_DescriptorImpl_emptyCredentialsId() {
        return holder.format("Builder.DescriptorImpl.emptyCredentialsId");
    }

    /**
     * Key {@code Builder.DescriptorImpl.emptyCredentialsId}: {@code

     * Credentials is required}.
     * 
     * @return
     *     {@code Credentials is required}
     */
    public static Localizable _Builder_DescriptorImpl_emptyCredentialsId() {
        return new Localizable(holder, "Builder.DescriptorImpl.emptyCredentialsId");
    }

    /**
     * Key {@code Installer.displayName}: {@code Install from github.com}.
     * 
     * @return
     *     {@code Install from github.com}
     */
    public static String Installer_displayName() {
        return holder.format("Installer.displayName");
    }

    /**
     * Key {@code Installer.displayName}: {@code Install from github.com}.
     * 
     * @return
     *     {@code Install from github.com}
     */
    public static Localizable _Installer_displayName() {
        return new Localizable(holder, "Installer.displayName");
    }

    /**
     * Key {@code Publisher.ParsingFile}: {@code Parsing file}.
     * 
     * @return
     *     {@code Parsing file}
     */
    public static String Publisher_ParsingFile() {
        return holder.format("Publisher.ParsingFile");
    }

    /**
     * Key {@code Publisher.ParsingFile}: {@code Parsing file}.
     * 
     * @return
     *     {@code Parsing file}
     */
    public static Localizable _Publisher_ParsingFile() {
        return new Localizable(holder, "Publisher.ParsingFile");
    }

    /**
     * Key {@code Publisher.NotParsable}: {@code Unable to parse {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to parse {0}}
     */
    public static String Publisher_NotParsable(Object arg0) {
        return holder.format("Publisher.NotParsable", arg0);
    }

    /**
     * Key {@code Publisher.NotParsable}: {@code Unable to parse {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to parse {0}}
     */
    public static Localizable _Publisher_NotParsable(Object arg0) {
        return new Localizable(holder, "Publisher.NotParsable", arg0);
    }

    /**
     * Key {@code Builder.Skip}: {@code Skipping Dependency-Check analysis}.
     * 
     * @return
     *     {@code Skipping Dependency-Check analysis}
     */
    public static String Builder_Skip() {
        return holder.format("Builder.Skip");
    }

    /**
     * Key {@code Builder.Skip}: {@code Skipping Dependency-Check analysis}.
     * 
     * @return
     *     {@code Skipping Dependency-Check analysis}
     */
    public static Localizable _Builder_Skip() {
        return new Localizable(holder, "Builder.Skip");
    }

    /**
     * Key {@code Builder.InvalidNode}: {@code Not running on a build node.

     * cannot continue.}.
     * 
     * @return
     *     {@code Not running on a build node. cannot continue.}
     */
    public static String Builder_InvalidNode() {
        return holder.format("Builder.InvalidNode");
    }

    /**
     * Key {@code Builder.InvalidNode}: {@code Not running on a build node.

     * cannot continue.}.
     * 
     * @return
     *     {@code Not running on a build node. cannot continue.}
     */
    public static Localizable _Builder_InvalidNode() {
        return new Localizable(holder, "Builder.InvalidNode");
    }

    /**
     * Key {@code Builder.noExecutableFound}: {@code Couldn’t find any

     * executable in "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Couldn’t find any executable in "{0}"}
     */
    public static String Builder_noExecutableFound(Object arg0) {
        return holder.format("Builder.noExecutableFound", arg0);
    }

    /**
     * Key {@code Builder.noExecutableFound}: {@code Couldn’t find any

     * executable in "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Couldn’t find any executable in "{0}"}
     */
    public static Localizable _Builder_noExecutableFound(Object arg0) {
        return new Localizable(holder, "Builder.noExecutableFound", arg0);
    }

    /**
     * Key {@code Builder.InstallationNotSpecified}: {@code A

     * Dependency-Check installation was not specified. Please configure the

     * build and specify a Dependency-Check installation to use.}.
     * 
     * @return
     *     {@code A Dependency-Check installation was not specified. Please

     *     configure the build and specify a Dependency-Check installation to

     *     use.}
     */
    public static String Builder_InstallationNotSpecified() {
        return holder.format("Builder.InstallationNotSpecified");
    }

    /**
     * Key {@code Builder.InstallationNotSpecified}: {@code A

     * Dependency-Check installation was not specified. Please configure the

     * build and specify a Dependency-Check installation to use.}.
     * 
     * @return
     *     {@code A Dependency-Check installation was not specified. Please

     *     configure the build and specify a Dependency-Check installation to

     *     use.}
     */
    public static Localizable _Builder_InstallationNotSpecified() {
        return new Localizable(holder, "Builder.InstallationNotSpecified");
    }

    /**
     * Key {@code Publisher.Name}: {@code Publish Dependency-Check results}.
     * 
     * @return
     *     {@code Publish Dependency-Check results}
     */
    public static String Publisher_Name() {
        return holder.format("Publisher.Name");
    }

    /**
     * Key {@code Publisher.Name}: {@code Publish Dependency-Check results}.
     * 
     * @return
     *     {@code Publish Dependency-Check results}
     */
    public static Localizable _Publisher_Name() {
        return new Localizable(holder, "Publisher.Name");
    }

    /**
     * Key {@code Publisher.Threshold.Exceed}: {@code Findings exceed

     * configured thresholds}.
     * 
     * @return
     *     {@code Findings exceed configured thresholds}
     */
    public static String Publisher_Threshold_Exceed() {
        return holder.format("Publisher.Threshold.Exceed");
    }

    /**
     * Key {@code Publisher.Threshold.Exceed}: {@code Findings exceed

     * configured thresholds}.
     * 
     * @return
     *     {@code Findings exceed configured thresholds}
     */
    public static Localizable _Publisher_Threshold_Exceed() {
        return new Localizable(holder, "Publisher.Threshold.Exceed");
    }

    /**
     * Key {@code Builder.nodeOffline}: {@code Cannot get installation for

     * node, since it is not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it is not online}
     */
    public static String Builder_nodeOffline() {
        return holder.format("Builder.nodeOffline");
    }

    /**
     * Key {@code Builder.nodeOffline}: {@code Cannot get installation for

     * node, since it is not online}.
     * 
     * @return
     *     {@code Cannot get installation for node, since it is not online}
     */
    public static Localizable _Builder_nodeOffline() {
        return new Localizable(holder, "Builder.nodeOffline");
    }

    /**
     * Key {@code Installer.failedToUnpack}: {@code Failed to unpack {0} ({1}

     * bytes read)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to unpack {0} ({1} bytes read)}
     */
    public static String Installer_failedToUnpack(Object arg0, Object arg1) {
        return holder.format("Installer.failedToUnpack", arg0, arg1);
    }

    /**
     * Key {@code Installer.failedToUnpack}: {@code Failed to unpack {0} ({1}

     * bytes read)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to unpack {0} ({1} bytes read)}
     */
    public static Localizable _Installer_failedToUnpack(Object arg0, Object arg1) {
        return new Localizable(holder, "Installer.failedToUnpack", arg0, arg1);
    }

    /**
     * Key {@code Publisher.FailBuild}: {@code Dependency-Check scan

     * failed.}.
     * 
     * @return
     *     {@code Dependency-Check scan failed.}
     */
    public static String Publisher_FailBuild() {
        return holder.format("Publisher.FailBuild");
    }

    /**
     * Key {@code Publisher.FailBuild}: {@code Dependency-Check scan

     * failed.}.
     * 
     * @return
     *     {@code Dependency-Check scan failed.}
     */
    public static Localizable _Publisher_FailBuild() {
        return new Localizable(holder, "Publisher.FailBuild");
    }

    /**
     * Key {@code Builder.Name}: {@code Invoke Dependency-Check}.
     * 
     * @return
     *     {@code Invoke Dependency-Check}
     */
    public static String Builder_Name() {
        return holder.format("Builder.Name");
    }

    /**
     * Key {@code Builder.Name}: {@code Invoke Dependency-Check}.
     * 
     * @return
     *     {@code Invoke Dependency-Check}
     */
    public static Localizable _Builder_Name() {
        return new Localizable(holder, "Builder.Name");
    }

    /**
     * Key {@code Builder.noInstallationFound}: {@code No installation {0}

     * found. Please define one in manager Jenkins.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No installation {0} found. Please define one in manager

     *     Jenkins.}
     */
    public static String Builder_noInstallationFound(Object arg0) {
        return holder.format("Builder.noInstallationFound", arg0);
    }

    /**
     * Key {@code Builder.noInstallationFound}: {@code No installation {0}

     * found. Please define one in manager Jenkins.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No installation {0} found. Please define one in manager

     *     Jenkins.}
     */
    public static Localizable _Builder_noInstallationFound(Object arg0) {
        return new Localizable(holder, "Builder.noInstallationFound", arg0);
    }

    /**
     * Key {@code SystemTools.nodeNotAvailable}: {@code Node could be offline

     * or there are no executor defined for Node {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node could be offline or there are no executor defined for Node

     *     {0}}
     */
    public static String SystemTools_nodeNotAvailable(Object arg0) {
        return holder.format("SystemTools.nodeNotAvailable", arg0);
    }

    /**
     * Key {@code SystemTools.nodeNotAvailable}: {@code Node could be offline

     * or there are no executor defined for Node {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node could be offline or there are no executor defined for Node

     *     {0}}
     */
    public static Localizable _SystemTools_nodeNotAvailable(Object arg0) {
        return new Localizable(holder, "SystemTools.nodeNotAvailable", arg0);
    }

    /**
     * Key {@code Platform.unknown}: {@code Unknown OS name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown OS name: {0}}
     */
    public static String Platform_unknown(Object arg0) {
        return holder.format("Platform.unknown", arg0);
    }

    /**
     * Key {@code Platform.unknown}: {@code Unknown OS name: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unknown OS name: {0}}
     */
    public static Localizable _Platform_unknown(Object arg0) {
        return new Localizable(holder, "Platform.unknown", arg0);
    }

    /**
     * Key {@code Installation.displayName}: {@code Dependency-Check}.
     * 
     * @return
     *     {@code Dependency-Check}
     */
    public static String Installation_displayName() {
        return holder.format("Installation.displayName");
    }

    /**
     * Key {@code Installation.displayName}: {@code Dependency-Check}.
     * 
     * @return
     *     {@code Dependency-Check}
     */
    public static Localizable _Installation_displayName() {
        return new Localizable(holder, "Installation.displayName");
    }

    /**
     * Key {@code SystemTools.failureOnProperties}: {@code Error getting

     * system properties on remote Node}.
     * 
     * @return
     *     {@code Error getting system properties on remote Node}
     */
    public static String SystemTools_failureOnProperties() {
        return holder.format("SystemTools.failureOnProperties");
    }

    /**
     * Key {@code SystemTools.failureOnProperties}: {@code Error getting

     * system properties on remote Node}.
     * 
     * @return
     *     {@code Error getting system properties on remote Node}
     */
    public static Localizable _SystemTools_failureOnProperties() {
        return new Localizable(holder, "SystemTools.failureOnProperties");
    }

}
