/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.plugins.createjobadvanced.AbstractConfigurer;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import jenkins.model.BuildDiscarder;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;

public class JobConfigurer
extends AbstractConfigurer<Job<?, ?>, AuthorizationMatrixProperty> {
    protected JobConfigurer() {
    }

    @Override
    protected final void renameJob(@Nullable Item item, @NonNull String newName) throws IOException {
        if (null != newName && null != item && item instanceof Job) {
            Job job = (Job)item;
            job.renameTo(newName);
        }
    }

    @Override
    protected void doCreate(Item item) {
        CreateJobAdvancedPlugin cja;
        if (null != item && item instanceof Job && null != (cja = this.getPlugin())) {
            super.doCreate(item);
            Job job = (Job)item;
            if (cja.isActiveLogRotator()) {
                this.activateLogRotator((Item)job, cja);
            }
        }
    }

    @Override
    @Nullable
    protected final AuthorizationMatrixProperty getAuthorizationMatrixProperty(@Nullable Item item) {
        AuthorizationMatrixProperty result = null;
        if (null != item && item instanceof Job) {
            Job job = (Job)item;
            result = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
        }
        return result;
    }

    @Override
    protected final void removeProperty(@Nullable Item item, @Nullable AuthorizationMatrixProperty authProperty) {
        if (null != item && null != authProperty && item instanceof Job) {
            Job job = (Job)item;
            try {
                job.removeProperty(AuthorizationMatrixProperty.class);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "problem to remove granted permissions (template or copy job)", e);
            }
        }
    }

    @Override
    protected final Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries(@Nullable AuthorizationMatrixProperty authProperty) {
        HashMap<Object, Set<Object>> result = new HashMap<Permission, Set<PermissionEntry>>();
        if (null != authProperty) {
            result = new HashMap(authProperty.getGrantedPermissionEntries());
        }
        return result;
    }

    private final void activateLogRotator(Item item, CreateJobAdvancedPlugin cja) {
        Job job;
        if (null != item && null != cja && item instanceof Job && null == (job = (Job)item).getBuildDiscarder()) {
            LogRotator logrotator = new LogRotator(cja.getDaysToKeep(), cja.getNumToKeep(), cja.getArtifactDaysToKeep(), cja.getArtifactNumToKeep());
            try {
                job.setBuildDiscarder((BuildDiscarder)logrotator);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "error setting Logrotater", e);
            }
        }
    }

    @Nullable
    private final AuthorizationMatrixProperty.DescriptorImpl getAuthorizationPropertyDescriptor() {
        return (AuthorizationMatrixProperty.DescriptorImpl)Jenkins.get().getDescriptor(AuthorizationMatrixProperty.class);
    }

    @Override
    protected final void addAuthorizationMatrixProperty(@Nullable Item item, @Nullable AuthorizationMatrixProperty authProperty) throws IOException {
        if (null != authProperty && null != item && item instanceof Job) {
            log.finer("> " + this.getClass().getName() + ".addAuthorizationMatrixProperty(Item, AuthorizationMatrixProperty)");
            Job job = (Job)item;
            job.addProperty((JobProperty)authProperty);
            log.finer("< " + this.getClass().getName() + ".addAuthorizationMatrixProperty(Item, AuthorizationMatrixProperty)");
        }
    }

    @Override
    @Nullable
    protected final AuthorizationMatrixProperty createAuthorizationMatrixProperty() {
        AuthorizationMatrixProperty result = null;
        AuthorizationMatrixProperty.DescriptorImpl propDescriptor = this.getAuthorizationPropertyDescriptor();
        if (propDescriptor != null) {
            result = propDescriptor.create();
        }
        return result;
    }

    @Override
    protected final void setInheritanceStrategy(@Nullable AuthorizationMatrixProperty authProperty, @Nullable InheritanceStrategy inheritanceStrategy) {
        if (null == inheritanceStrategy) {
            log.warning("inheritanceStrategy parameter is null");
            return;
        }
        if (null == authProperty) {
            log.warning("authProperty parameter is null");
            return;
        }
        authProperty.setInheritanceStrategy(inheritanceStrategy);
    }

    @Override
    protected final void addPermission(@Nullable AuthorizationMatrixProperty authProperty, @Nullable Permission perm, @Nullable PermissionEntry permEntry) {
        if (permEntry != null && perm != null && null != authProperty) {
            authProperty.add(perm, permEntry);
        }
    }

    @Override
    protected final boolean showPermission(@Nullable Permission perm) {
        AuthorizationMatrixProperty.DescriptorImpl propDescriptor;
        boolean result = false;
        if (perm != null && null != (propDescriptor = this.getAuthorizationPropertyDescriptor())) {
            result = propDescriptor.showPermission(perm);
        }
        return result;
    }
}

