/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.createjobadvanced.DynamicPermissionConfig;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;

public class CreateJobAdvancedPlugin
extends Plugin {
    private static final Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());
    private boolean autoOwnerRights;
    private boolean autoPublicBrowse;
    private boolean replaceSpace;
    private boolean activeLogRotator;
    private int daysToKeep = -1;
    private int numToKeep = -1;
    private int artifactDaysToKeep = -1;
    private int artifactNumToKeep = -1;
    private boolean activeDynamicPermissions;
    private String extractPattern;
    private boolean mvnArchivingDisabled;
    private boolean mvnPerModuleEmail;
    private final List<DynamicPermissionConfig> dynamicPermissionConfigs = new ArrayList<DynamicPermissionConfig>();

    public List<DynamicPermissionConfig> getDynamicPermissionConfigs() {
        return this.dynamicPermissionConfigs;
    }

    @Deprecated
    public CreateJobAdvancedPlugin() {
    }

    public void start() throws Exception {
        super.start();
        log.info("Create job advanced plugin started ...");
        this.load();
    }

    public void configure(StaplerRequest2 req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.autoOwnerRights = formData.optBoolean("security", false);
        this.autoPublicBrowse = formData.optBoolean("public", false);
        this.replaceSpace = formData.optBoolean("jobspacesinname", false);
        this.mvnArchivingDisabled = formData.optBoolean("mvnArchivingDisabled", false);
        this.mvnPerModuleEmail = formData.optBoolean("mvnPerModuleEmail", false);
        JSONObject activeLogRotatorJson = formData.optJSONObject("activeLogRotator");
        if (activeLogRotatorJson != null) {
            this.activeLogRotator = true;
            this.daysToKeep = activeLogRotatorJson.optInt("daysToKeep", -1);
            this.numToKeep = activeLogRotatorJson.optInt("numToKeep", -1);
            this.artifactDaysToKeep = activeLogRotatorJson.optInt("artifactDaysToKeep", -1);
            this.artifactNumToKeep = activeLogRotatorJson.optInt("artifactNumToKeep", -1);
        } else {
            this.activeLogRotator = false;
        }
        JSONObject activeDynamicPermissionsJson = formData.optJSONObject("activeDynamicPermissions");
        if (activeDynamicPermissionsJson != null) {
            this.activeDynamicPermissions = true;
            this.extractPattern = activeDynamicPermissionsJson.optString("extractPattern", "");
            this.dynamicPermissionConfigs.clear();
            Object cfgs = activeDynamicPermissionsJson.get("cfgs");
            if (cfgs instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)cfgs;
                for (Object object : jsonArray) {
                    this.addDynamicPermission(req, (JSONObject)object);
                }
            } else {
                this.addDynamicPermission(req, (JSONObject)cfgs);
            }
        } else {
            this.activeDynamicPermissions = false;
            this.extractPattern = null;
            this.dynamicPermissionConfigs.clear();
        }
        this.save();
    }

    private void addDynamicPermission(StaplerRequest2 req, JSONObject jsonObject) {
        DynamicPermissionConfig dynPerm = (DynamicPermissionConfig)req.bindJSON(DynamicPermissionConfig.class, jsonObject);
        Map<String, List<Permission>> allPossiblePermissions = CreateJobAdvancedPlugin.getAllPossiblePermissions();
        for (Map.Entry<String, List<Permission>> entry : allPossiblePermissions.entrySet()) {
            for (Permission permission : entry.getValue()) {
                String enabled = jsonObject.getString(permission.getId());
                if (!Boolean.parseBoolean(enabled)) continue;
                dynPerm.addPermissionId(permission.getId());
                log.log(Level.FINE, "enable {0}", new String[]{permission.getId()});
            }
        }
        this.dynamicPermissionConfigs.add(dynPerm);
    }

    public static Map<String, List<Permission>> getAllPossiblePermissions() {
        TreeMap<String, List<Permission>> enabledPerms = new TreeMap<String, List<Permission>>();
        CreateJobAdvancedPlugin.addEnabledPermissionsForGroup(enabledPerms, Item.class);
        CreateJobAdvancedPlugin.addEnabledPermissionsForGroup(enabledPerms, Run.class);
        return enabledPerms;
    }

    public static String impliedByList(@Nullable Permission p) {
        ArrayList<Permission> impliedBys = new ArrayList<Permission>();
        while (null != p && null != p.impliedBy) {
            p = p.impliedBy;
            impliedBys.add(p);
        }
        return StringUtils.join((Collection)impliedBys.stream().map(Permission::getId).collect(Collectors.toList()), (String)" ");
    }

    private static void addEnabledPermissionsForGroup(Map<String, List<Permission>> allEnabledPerms, Class<?> owner) {
        PermissionGroup permissionGroup = PermissionGroup.get(owner);
        if (permissionGroup != null) {
            ArrayList<Permission> enabledPerms = new ArrayList<Permission>();
            List permissions = permissionGroup.getPermissions();
            for (Permission permission : permissions) {
                if (!permission.enabled) continue;
                enabledPerms.add(permission);
            }
            if (!enabledPerms.isEmpty()) {
                allEnabledPerms.put(permissionGroup.title.toString(), enabledPerms);
            }
        }
    }

    public boolean isAutoOwnerRights() {
        return this.autoOwnerRights;
    }

    public boolean isAutoPublicBrowse() {
        return this.autoPublicBrowse;
    }

    public boolean isReplaceSpace() {
        return this.replaceSpace;
    }

    public boolean isActiveLogRotator() {
        return this.activeLogRotator;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public int getArtifactDaysToKeep() {
        return this.artifactDaysToKeep;
    }

    public int getArtifactNumToKeep() {
        return this.artifactNumToKeep;
    }

    public String getExtractPattern() {
        return this.extractPattern;
    }

    public boolean isActiveDynamicPermissions() {
        return this.activeDynamicPermissions;
    }

    public boolean isMvnArchivingDisabled() {
        return this.mvnArchivingDisabled;
    }

    public boolean isMvnPerModuleEmail() {
        return this.mvnPerModuleEmail;
    }
}

