/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v3.MergedDefectDataObj;
import hudson.Util;
import hudson.model.Descriptor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefectFilters {
    private List<String> classifications;
    private List<String> actions;
    private List<String> severities;
    private List<String> components;
    private List<String> checkers;
    private List<String> ignoredCheckers;
    private Date cutOffDate;

    @DataBoundConstructor
    public DefectFilters(List<String> actions, List<String> classifications, List<String> severities, List<String> components, List<String> checkers, String cutOffDate) throws Descriptor.FormException {
        this.classifications = Util.fixNull(classifications);
        this.actions = Util.fixNull(actions);
        this.severities = Util.fixNull(severities);
        this.components = Util.fixNull(components);
        this.checkers = Util.fixNull(checkers);
        cutOffDate = Util.fixEmpty((String)cutOffDate);
        if (cutOffDate != null) {
            try {
                this.cutOffDate = new SimpleDateFormat("yyyy-MM-dd").parse(cutOffDate);
            }
            catch (ParseException e) {
                this.cutOffDate = null;
            }
        } else {
            this.cutOffDate = null;
        }
    }

    void invertCheckers(Set<String> allCheckers, List<String> allClassifications, List<String> allActions, List<String> allSeverities, List<String> allComponents) {
        if (this.classifications.isEmpty() && this.checkers.isEmpty() && this.actions.isEmpty() && this.components.isEmpty() && this.severities.isEmpty()) {
            this.ignoredCheckers = new ArrayList<String>();
            this.actions = allActions;
            this.severities = allSeverities;
            this.components = allComponents;
            this.classifications = allClassifications;
        } else {
            this.ignoredCheckers = new ArrayList<String>(allCheckers);
            this.ignoredCheckers.removeAll(this.checkers);
            this.checkers = null;
        }
    }

    public boolean isClassificationSelected(String action) {
        return this.classifications.contains(action);
    }

    public boolean isActionSelected(String action) {
        return this.actions.contains(action);
    }

    public boolean isSeveritySelected(String severity) {
        return this.severities.contains(severity);
    }

    public boolean isComponentSelected(String component) {
        return this.components.contains(component);
    }

    public boolean isCheckerSelected(String checker) {
        return !this.ignoredCheckers.contains(checker);
    }

    public String getCutOffDate() {
        if (this.cutOffDate == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.cutOffDate);
    }

    public boolean matches(MergedDefectDataObj defect) {
        return this.isActionSelected(defect.getAction()) && this.isClassificationSelected(defect.getClassification()) && this.isSeveritySelected(defect.getSeverity()) && this.isComponentSelected(defect.getComponentName()) && this.isCheckerSelected(defect.getChecker()) && Arrays.asList("New", "Triaged", "Various").contains(defect.getStatus()) && (this.cutOffDate == null || defect.getFirstDetected().toGregorianCalendar().getTime().after(this.cutOffDate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefectFilters that = (DefectFilters)o;
        if (this.actions != null ? !((Object)this.actions).equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.checkers != null ? !((Object)this.checkers).equals(that.checkers) : that.checkers != null) {
            return false;
        }
        if (this.classifications != null ? !((Object)this.classifications).equals(that.classifications) : that.classifications != null) {
            return false;
        }
        if (this.components != null ? !((Object)this.components).equals(that.components) : that.components != null) {
            return false;
        }
        if (this.cutOffDate != null ? !this.cutOffDate.equals(that.cutOffDate) : that.cutOffDate != null) {
            return false;
        }
        return !(this.severities != null ? !((Object)this.severities).equals(that.severities) : that.severities != null);
    }

    public int hashCode() {
        int result = this.classifications != null ? ((Object)this.classifications).hashCode() : 0;
        result = 31 * result + (this.actions != null ? ((Object)this.actions).hashCode() : 0);
        result = 31 * result + (this.severities != null ? ((Object)this.severities).hashCode() : 0);
        result = 31 * result + (this.components != null ? ((Object)this.components).hashCode() : 0);
        result = 31 * result + (this.checkers != null ? ((Object)this.checkers).hashCode() : 0);
        result = 31 * result + (this.cutOffDate != null ? this.cutOffDate.hashCode() : 0);
        return result;
    }
}

