/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v3.ComponentDataObj;
import com.coverity.ws.v3.ComponentMapDataObj;
import com.coverity.ws.v3.ComponentMapFilterSpecDataObj;
import com.coverity.ws.v3.CovRemoteServiceException_Exception;
import com.coverity.ws.v3.MergedDefectDataObj;
import com.coverity.ws.v3.ProjectDataObj;
import com.coverity.ws.v3.SnapshotIdDataObj;
import com.coverity.ws.v3.StreamDataObj;
import com.coverity.ws.v3.StreamIdDataObj;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityInstallation;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityMailSender;
import jenkins.plugins.coverity.CoverityProjectAction;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverityPublisher
extends Recorder {
    private static final Logger logger = Logger.getLogger(CoverityPublisher.class.getName());
    private final String cimInstance;
    private final InvocationAssistance invocationAssistance;
    private final String project;
    private final String stream;
    private final boolean failBuild;
    private final boolean keepIntDir;
    private final DefectFilters defectFilters;
    private final CoverityMailSender mailSender;

    @DataBoundConstructor
    public CoverityPublisher(String cimInstance, InvocationAssistance invocationAssistance, String project, String stream, boolean failBuild, boolean keepIntDir, DefectFilters defectFilters, CoverityMailSender mailSender) {
        this.cimInstance = cimInstance;
        this.invocationAssistance = invocationAssistance;
        this.project = project;
        this.stream = stream;
        this.defectFilters = defectFilters;
        this.failBuild = failBuild;
        this.mailSender = mailSender;
        this.keepIntDir = keepIntDir;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public String getCimInstance() {
        return this.cimInstance;
    }

    public InvocationAssistance getInvocationAssistance() {
        return this.invocationAssistance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public boolean isKeepIntDir() {
        return this.keepIntDir;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public CoverityMailSender getMailSender() {
        return this.mailSender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoverityPublisher that = (CoverityPublisher)((Object)o);
        if (!this.cimInstance.equals(that.cimInstance)) {
            return false;
        }
        if (this.defectFilters != null ? !this.defectFilters.equals(that.defectFilters) : that.defectFilters != null) {
            return false;
        }
        if (this.invocationAssistance != null ? !this.invocationAssistance.equals(that.invocationAssistance) : that.invocationAssistance != null) {
            return false;
        }
        if (!this.project.equals(that.project)) {
            return false;
        }
        return this.stream.equals(that.stream);
    }

    public int hashCode() {
        int result = this.cimInstance.hashCode();
        result = 31 * result + (this.invocationAssistance != null ? this.invocationAssistance.hashCode() : 0);
        result = 31 * result + this.project.hashCode();
        result = 31 * result + this.stream.hashCode();
        result = 31 * result + (this.defectFilters != null ? this.defectFilters.hashCode() : 0);
        return result;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CoverityProjectAction(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        CIMInstance cim = this.getDescriptor().getInstance(this.cimInstance);
        CoverityTempDir temp = null;
        String language = null;
        try {
            language = cim.getStream(this.stream).getLanguage();
        }
        catch (CovRemoteServiceException_Exception e) {
            e.printStackTrace(listener.error("Error while retrieving stream information for " + this.stream));
            return false;
        }
        if (this.invocationAssistance != null) {
            try {
                int result;
                String csharpAssemblies;
                boolean isCsharp = "CSHARP".equals(language);
                if (isCsharp && this.invocationAssistance.getCsharpAssemblies() != null) {
                    String csharpAssembliesStr = this.invocationAssistance.getCsharpAssemblies();
                    listener.getLogger().println("[Coverity] C# Project detected, assemblies to analyze are: " + csharpAssembliesStr);
                }
                String covAnalyze = null;
                covAnalyze = "JAVA".equals(language) ? "cov-analyze-java" : (isCsharp ? "cov-analyze-cs" : "cov-analyze");
                String covCommitDefects = "cov-commit-defects";
                Node node = Executor.currentExecutor().getOwner().getNode();
                String home = this.getDescriptor().getHome(node, build.getEnvironment((TaskListener)listener));
                if (home != null) {
                    covAnalyze = new FilePath(launcher.getChannel(), home).child("bin").child(covAnalyze).getRemote();
                    covCommitDefects = new FilePath(launcher.getChannel(), home).child("bin").child(covCommitDefects).getRemote();
                }
                CoverityLauncherDecorator.SKIP.set(true);
                temp = (CoverityTempDir)build.getAction(CoverityTempDir.class);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(covAnalyze);
                cmd.add("--dir");
                cmd.add(temp.tempDir.getRemote());
                if (isCsharp && (csharpAssemblies = this.invocationAssistance.getCsharpAssemblies()) != null) {
                    cmd.add(csharpAssemblies);
                }
                listener.getLogger().println("[Coverity] cmd so far is: " + ((Object)cmd).toString());
                if (this.invocationAssistance.getAnalyzeArguments() != null) {
                    for (String arg : Util.tokenize((String)this.invocationAssistance.getAnalyzeArguments())) {
                        cmd.add(arg);
                    }
                }
                if ((result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join()) != 0) {
                    listener.getLogger().println("[Coverity] " + covAnalyze + " returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    int len$ = 0;
                    return len$ != 0;
                }
                cmd = new ArrayList();
                cmd.add(covCommitDefects);
                cmd.add("--dir");
                cmd.add(temp.tempDir.getRemote());
                cmd.add("--host");
                cmd.add(cim.getHost());
                cmd.add("--port");
                cmd.add(Integer.toString(cim.getPort()));
                cmd.add("--stream");
                cmd.add(this.stream);
                cmd.add("--user");
                cmd.add(cim.getUser());
                if (this.invocationAssistance.getCommitArguments() != null) {
                    for (String arg : Util.tokenize((String)this.invocationAssistance.getCommitArguments())) {
                        cmd.add(arg);
                    }
                }
                ArgumentListBuilder args = new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]));
                result = launcher.launch().cmds(args).envs(Collections.singletonMap("COVERITY_PASSPHRASE", cim.getPassword())).stdout((TaskListener)listener).stderr((OutputStream)listener.getLogger()).join();
                if (result != 0) {
                    listener.getLogger().println("[Coverity] cov-commit-defects returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    int len$ = 0;
                    return len$ != 0;
                }
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
                if (temp != null) {
                    if (!this.keepIntDir || temp.def) {
                        listener.getLogger().println("[Coverity] deleting intermediate directory");
                        temp.tempDir.deleteRecursive();
                    } else {
                        listener.getLogger().println("[Coverity] preserving intermediate directory: " + temp.tempDir);
                    }
                }
            }
        }
        Pattern snapshotPattern = Pattern.compile(".*New snapshot ID (\\d*) added.");
        BufferedReader reader = new BufferedReader(build.getLogReader());
        String line = null;
        long snapshotId = -1L;
        try {
            while ((line = reader.readLine()) != null && snapshotId < 0L) {
                Matcher m = snapshotPattern.matcher(line);
                if (!m.matches()) continue;
                snapshotId = Long.parseLong(m.group(1));
            }
        }
        finally {
            reader.close();
        }
        if (snapshotId == -1L) {
            listener.getLogger().println("[Coverity] No snapshot ID found in build log");
            build.setResult(Result.FAILURE);
            return false;
        }
        listener.getLogger().println("[Coverity] Found snapshot ID " + snapshotId);
        try {
            String rootUrl;
            listener.getLogger().println("[Coverity] Fetching defects for stream " + this.stream);
            StreamIdDataObj streamId = new StreamIdDataObj();
            streamId.setName(this.stream);
            streamId.setType("STATIC");
            SnapshotIdDataObj snapshot = new SnapshotIdDataObj();
            snapshot.setId(snapshotId);
            List<Long> cids = cim.getDefectService().getCIDsForSnapshot(snapshot);
            listener.getLogger().println("[Coverity] Found " + cids.size() + " defects");
            List<MergedDefectDataObj> defects = cim.getDefects(this.stream, cids);
            HashSet<String> checkers = new HashSet<String>();
            for (MergedDefectDataObj defect : defects) {
                checkers.add(defect.getChecker());
            }
            this.getDescriptor().updateCheckers(language, checkers);
            ArrayList<Long> matchingDefects = new ArrayList<Long>();
            XStream2 xs = new XStream2();
            if (this.defectFilters != null) {
                // empty if block
            }
            for (MergedDefectDataObj defect : defects) {
                if (this.defectFilters == null) {
                    matchingDefects.add(defect.getCid());
                    continue;
                }
                boolean match = this.defectFilters.matches(defect);
                if (!match) continue;
                matchingDefects.add(defect.getCid());
            }
            if (!matchingDefects.isEmpty()) {
                listener.getLogger().println("[Coverity] Found " + matchingDefects.size() + " defects matching all filters: " + matchingDefects);
                if (this.failBuild && build.getResult().isBetterThan(Result.FAILURE)) {
                    build.setResult(Result.FAILURE);
                }
            } else {
                listener.getLogger().println("[Coverity] No defects matched all filters.");
            }
            CoverityBuildAction action = new CoverityBuildAction(build, this.project, this.stream, this.cimInstance, matchingDefects);
            build.addAction((Action)action);
            if (!matchingDefects.isEmpty() && this.mailSender != null) {
                this.mailSender.execute(action, listener);
            }
            if ((rootUrl = Hudson.getInstance().getRootUrl()) != null) {
                listener.getLogger().println("Coverity details: " + Hudson.getInstance().getRootUrl() + build.getUrl() + action.getUrlName());
            }
        }
        catch (CovRemoteServiceException_Exception e) {
            e.printStackTrace(listener.error("[Coverity] An error occurred while fetching defects"));
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    public String getLanguage() throws IOException, CovRemoteServiceException_Exception {
        return this.getDescriptor().getInstance(this.cimInstance).getStream(this.stream).getLanguage();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<CIMInstance> instances = new ArrayList<CIMInstance>();
        private String home;
        private String javaCheckers;
        private String cxxCheckers;
        private String csharpCheckers;

        public DescriptorImpl() {
            super(CoverityPublisher.class);
            this.load();
            this.setJavaCheckers(this.javaCheckers);
            this.setCxxCheckers(this.cxxCheckers);
            this.setCsharpCheckers(this.csharpCheckers);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.home = Util.fixEmpty((String)this.home);
            this.save();
            return true;
        }

        public String getHome() {
            return this.home;
        }

        public void setHome(String home) {
            this.home = home;
        }

        public String getJavaCheckers() {
            return this.javaCheckers;
        }

        public void setJavaCheckers(String javaCheckers) {
            this.javaCheckers = Util.fixEmpty((String)javaCheckers);
            try {
                if (this.javaCheckers == null) {
                    this.javaCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("java-checkers.txt"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getCxxCheckers() {
            return this.cxxCheckers;
        }

        public void setCxxCheckers(String cxxCheckers) {
            this.cxxCheckers = Util.fixEmpty((String)cxxCheckers);
            try {
                if (this.cxxCheckers == null) {
                    this.cxxCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("cxx-checkers.txt"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getCsharpCheckers() {
            return this.csharpCheckers;
        }

        public void setCsharpCheckers(String csharpCheckers) {
            this.csharpCheckers = Util.fixEmpty((String)csharpCheckers);
            try {
                if (this.csharpCheckers == null) {
                    this.csharpCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("csharp-checkers.txt"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getHome(Node node, EnvVars environment) {
            CoverityInstallation install = (CoverityInstallation)node.getNodeProperties().get(CoverityInstallation.class);
            if (install != null) {
                return install.forEnvironment(environment).getHome();
            }
            if (this.home != null) {
                return new CoverityInstallation(this.home).forEnvironment(environment).getHome();
            }
            return null;
        }

        public void setInstances(List<CIMInstance> instances) {
            this.instances = instances;
        }

        public List<CIMInstance> getInstances() {
            return this.instances;
        }

        public CIMInstance getInstance(String name) {
            for (CIMInstance instance : this.instances) {
                if (!instance.getName().equals(name)) continue;
                return instance;
            }
            return null;
        }

        public String getDisplayName() {
            return "Coverity";
        }

        public FormValidation doCheckInstance(@QueryParameter String host, @QueryParameter int port, @QueryParameter boolean useSSL, @QueryParameter String user, @QueryParameter String password) throws IOException {
            return new CIMInstance("", host, port, user, password, useSSL).doCheck();
        }

        public FormValidation doCheckCutOffDate(@QueryParameter String value) throws Descriptor.FormException {
            try {
                if (!StringUtils.isEmpty((String)value)) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"yyyy-MM-dd expected");
            }
        }

        public ListBoxModel doFillCimInstanceItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("");
            for (CIMInstance instance : this.instances) {
                result.add(instance.getName());
            }
            return result;
        }

        public ListBoxModel doFillProjectItems(@QueryParameter String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            if (!StringUtils.isEmpty((String)cimInstance)) {
                for (ProjectDataObj project : this.getInstance(cimInstance).getProjects()) {
                    ListBoxModel streams = this.doFillStreamItems(cimInstance, project.getId().getName());
                    if (streams.isEmpty()) continue;
                    result.add(project.getId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillStreamItems(@QueryParameter String cimInstance, @QueryParameter String project) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            if (StringUtils.isEmpty((String)project)) {
                return result;
            }
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                for (StreamDataObj stream : instance.getStaticStreams(project)) {
                    if (!"JAVA".equals(stream.getLanguage()) && !"CXX".equals(stream.getLanguage()) && !"CSHARP".equals(stream.getLanguage())) continue;
                    result.add(stream.getId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillClassificationDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                for (String classification : this.getInstance(cimInstance).getConfigurationService().getClassifications()) {
                    result.add(classification);
                }
            }
            return result;
        }

        public ListBoxModel doFillActionDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                for (String action : this.getInstance(cimInstance).getConfigurationService().getActions()) {
                    result.add(action);
                }
            }
            return result;
        }

        public ListBoxModel doFillSeveritiesDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                for (String action : this.getInstance(cimInstance).getConfigurationService().getSeverities()) {
                    result.add(action);
                }
            }
            return result;
        }

        public ListBoxModel doFillComponentDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null && !StringUtils.isEmpty((String)streamId)) {
                StreamDataObj stream = instance.getStream(streamId);
                String componentMapId = stream.getComponentMapId().getName();
                ComponentMapFilterSpecDataObj componentMapFilterSpec = new ComponentMapFilterSpecDataObj();
                componentMapFilterSpec.setNamePattern(componentMapId);
                for (ComponentMapDataObj map : instance.getConfigurationService().getComponentMaps(componentMapFilterSpec)) {
                    for (ComponentDataObj component : map.getComponents()) {
                        result.add(component.getComponentId().getName());
                    }
                }
            }
            return result;
        }

        public ListBoxModel doFillCheckerDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            if (StringUtils.isEmpty((String)streamId)) {
                return new ListBoxModel();
            }
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance == null) {
                return new ListBoxModel();
            }
            StreamDataObj stream = instance.getStream(streamId);
            String type = stream.getLanguage();
            if ("CXX".equals(type)) {
                return this.split(this.cxxCheckers);
            }
            if ("JAVA".equals(type)) {
                return this.split(this.javaCheckers);
            }
            if ("CSHARP".equals(type)) {
                return this.split(this.csharpCheckers);
            }
            return new ListBoxModel();
        }

        private ListBoxModel split(String string) {
            ListBoxModel result = new ListBoxModel();
            for (String s : string.split("[\r\n]")) {
                if ((s = Util.fixEmptyAndTrim((String)s)) == null) continue;
                result.add(s);
            }
            return result;
        }

        private Set<String> split2(String string) {
            TreeSet<String> result = new TreeSet<String>();
            for (String s : string.split("[\r\n]")) {
                if ((s = Util.fixEmptyAndTrim((String)s)) == null) continue;
                result.add(s);
            }
            return result;
        }

        public void doDefectFiltersConfig(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            logger.info(req.getSubmittedForm().toString());
            req.setAttribute("descriptor", (Object)this);
            JSONObject json = req.getSubmittedForm().getJSONObject(this.getJsonSafeClassName());
            if (json != null && !json.isNullObject()) {
                CoverityPublisher publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json));
                if (!(StringUtils.isEmpty((String)publisher.getCimInstance()) || StringUtils.isEmpty((String)publisher.getStream()) || StringUtils.isEmpty((String)publisher.getProject()))) {
                    try {
                        String language = publisher.getLanguage();
                        Set<String> allCheckers = this.split2(this.getCheckers(language));
                        DefectFilters defectFilters = publisher.getDefectFilters();
                        if (defectFilters != null) {
                            publisher.getDefectFilters().invertCheckers(allCheckers, DescriptorImpl.toStrings(this.doFillClassificationDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillActionDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillSeveritiesDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillComponentDefectFilterItems(publisher.getCimInstance(), publisher.getStream())));
                        }
                    }
                    catch (CovRemoteServiceException_Exception e) {
                        throw new IOException(e);
                    }
                }
                req.setAttribute("instance", (Object)publisher);
            }
            rsp.forward((Object)this, "defectFilters", req);
        }

        public FormValidation doCheckDate(@QueryParameter String date) {
            try {
                if (!StringUtils.isEmpty((String)date.trim())) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(date);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"Date in yyyy-mm-dd format expected");
            }
        }

        public String getCheckers(String language) {
            if ("CXX".equals(language)) {
                return this.cxxCheckers;
            }
            if ("JAVA".equals(language)) {
                return this.javaCheckers;
            }
            if ("CSHARP".equals(language)) {
                return this.csharpCheckers;
            }
            throw new IllegalArgumentException("Unknown language: " + language);
        }

        public void setCheckers(String language, Set<String> checkers) {
            if ("CXX".equals(language)) {
                this.cxxCheckers = this.join(checkers);
            } else if ("JAVA".equals(language)) {
                this.javaCheckers = this.join(checkers);
            } else if ("CSHARP".equals(language)) {
                this.csharpCheckers = this.join(checkers);
            } else {
                throw new IllegalArgumentException(language);
            }
        }

        public void updateCheckers(String language, Set<String> checkers) {
            String oldCheckers = this.getCheckers(language);
            TreeSet<String> newCheckers = new TreeSet<String>();
            TreeSet<String> c = new TreeSet<String>();
            for (ListBoxModel.Option option : this.split(oldCheckers)) {
                c.add(option.name);
            }
            for (String string : checkers) {
                if (!c.add(string)) continue;
                newCheckers.add(string);
            }
            this.setCheckers(language, c);
            this.save();
        }

        private String join(Collection<String> c) {
            StringBuffer result = new StringBuffer();
            for (String s : c) {
                result.append(s).append("\n");
            }
            return result.toString();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            logger.info(formData.toString());
            String cutOffDate = Util.fixEmpty((String)req.getParameter("cutOffDate"));
            try {
                if (cutOffDate != null) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(cutOffDate);
                }
            }
            catch (ParseException e) {
                throw new Descriptor.FormException("Could not parse date '" + cutOffDate + "', yyyy-MM-dd expected", "cutOffDate");
            }
            CoverityPublisher publisher = (CoverityPublisher)super.newInstance(req, formData);
            try {
                String language = publisher.getLanguage();
                Set<String> allCheckers = this.split2(this.getCheckers(language));
                DefectFilters defectFilters = publisher.getDefectFilters();
                if (defectFilters != null) {
                    defectFilters.invertCheckers(allCheckers, DescriptorImpl.toStrings(this.doFillClassificationDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillActionDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillSeveritiesDefectFilterItems(publisher.getCimInstance())), DescriptorImpl.toStrings(this.doFillComponentDefectFilterItems(publisher.getCimInstance(), publisher.getStream())));
                }
                return publisher;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static List<String> toStrings(ListBoxModel list) {
            ArrayList<String> result = new ArrayList<String>();
            for (ListBoxModel.Option option : list) {
                result.add(option.name);
            }
            return result;
        }
    }
}

