/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import jenkins.plugins.coverity.CoverityBuildAction;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverityProjectAction
implements Action {
    private final AbstractProject<?, ?> project;

    public CoverityProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "coverity";
    }

    public Graph getGraph() {
        return new GraphImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChartLabel
    implements Comparable<ChartLabel> {
        private AbstractBuild build;

        public ChartLabel(AbstractBuild build) {
            this.build = build;
        }

        public String getUrl() {
            return Hudson.getInstance().getRootUrl() + this.build.getUrl() + "coverity";
        }

        @Override
        public int compareTo(ChartLabel that) {
            return this.build.number - that.build.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChartLabel)) {
                return false;
            }
            ChartLabel that = (ChartLabel)o;
            return this.build == that.build;
        }

        public Color getColor() {
            return null;
        }

        public int hashCode() {
            return this.build.getDisplayName().hashCode();
        }

        public String toString() {
            String l = this.build.getDisplayName();
            String s = this.build.getBuiltOnStr();
            if (s != null) {
                l = l + ' ' + s;
            }
            return l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GraphImpl
    extends Graph {
        protected GraphImpl() {
            super(-1L, 600, 300);
        }

        protected DataSetBuilder<String, ChartLabel> createDataSet() {
            DataSetBuilder data = new DataSetBuilder();
            for (AbstractBuild build = (AbstractBuild)CoverityProjectAction.this.project.getLastCompletedBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
                CoverityBuildAction action = (CoverityBuildAction)build.getAction(CoverityBuildAction.class);
                if (action == null) continue;
                data.add((Number)action.getDefectIds().size(), (Comparable)((Object)""), (Comparable)new ChartLabel(build));
            }
            return data;
        }

        protected JFreeChart createGraph() {
            final CategoryDataset dataset = this.createDataSet().build();
            JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Defect Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.8f);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setAutoRange(true);
            StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                public Paint getItemPaint(int row, int column) {
                    ChartLabel key = (ChartLabel)dataset.getColumnKey(column);
                    if (key.getColor() != null) {
                        return key.getColor();
                    }
                    return super.getItemPaint(row, column);
                }

                public String generateURL(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return label.getUrl();
                }

                public String generateToolTip(CategoryDataset dataset2, int row, int column) {
                    ChartLabel label = (ChartLabel)dataset2.getColumnKey(column);
                    return label.build.getDisplayName() + " has " + ((CoverityBuildAction)label.build.getAction(CoverityBuildAction.class)).getDefectIds().size() + " defects";
                }
            };
            plot.setRenderer((CategoryItemRenderer)ar);
            ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

