/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v3.CovRemoteServiceException_Exception;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.InvocationAssistance;

@Extension
public class CoverityLauncherDecorator
extends LauncherDecorator {
    private static final Logger logger = Logger.getLogger(CoverityLauncherDecorator.class.getName());
    public static ThreadLocal<Boolean> SKIP = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public Launcher decorate(Launcher launcher, Node node) {
        FilePath temp;
        Executor executor = Executor.currentExecutor();
        if (executor == null) {
            return launcher;
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (!(exec instanceof AbstractBuild)) {
            return launcher;
        }
        AbstractBuild build = (AbstractBuild)exec;
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            return launcher;
        }
        InvocationAssistance ii = publisher.getInvocationAssistance();
        if (ii == null) {
            return launcher;
        }
        String cimInstanceName = publisher.getCimInstance();
        CIMInstance cim = publisher.getDescriptor().getInstance(publisher.getCimInstance());
        String streamName = publisher.getStream();
        String language = null;
        try {
            language = cim.getStream(streamName).getLanguage();
        }
        catch (CovRemoteServiceException_Exception e) {
            throw new RuntimeException("Error while retrieving stream information for " + streamName, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while retrieving stream information for " + streamName, e);
        }
        try {
            if (ii.getIntermediateDir() == null) {
                FilePath coverityDir = node.getRootPath().child("coverity");
                coverityDir.mkdirs();
                temp = coverityDir.createTempDir("temp-", null);
            } else {
                temp = new FilePath(node.getChannel(), ii.getIntermediateDir());
                temp.mkdirs();
            }
            build.addAction((Action)new CoverityTempDir(temp, ii.getIntermediateDir() == null));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating temporary directory for Coverity", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while creating temporary directory for Coverity");
        }
        if ("CSHARP".equals(language)) {
            logger.info("Stream " + streamName + " is of type CSHARP, skipping cov-build");
            return launcher;
        }
        try {
            String covBuild = "cov-build";
            TaskListener listener = launcher.getListener();
            String home = publisher.getDescriptor().getHome(node, build.getEnvironment(listener));
            if (home != null) {
                covBuild = new FilePath(node.getChannel(), home).child("bin").child(covBuild).getRemote();
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(covBuild);
            args.add("--dir");
            args.add(temp.getRemote());
            if (ii.getBuildArguments() != null) {
                for (String arg : Util.tokenize((String)ii.getBuildArguments())) {
                    args.add(arg);
                }
            }
            return new DecoratedLauncher(launcher, args.toArray(new String[args.size()]));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while creating temporary directory for Coverity");
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating temporary directory for Coverity", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedLauncher
    extends Launcher {
        private final Launcher decorated;
        private final String[] prefix;

        public DecoratedLauncher(Launcher decorated, String ... prefix) {
            super(decorated);
            this.decorated = decorated;
            this.prefix = prefix;
        }

        public Proc launch(Launcher.ProcStarter starter) throws IOException {
            if (!SKIP.get().booleanValue()) {
                List cmds = starter.cmds();
                cmds.addAll(0, Arrays.asList(this.prefix));
                starter.cmds(cmds);
                boolean[] masks = starter.masks();
                if (masks == null) {
                    masks = new boolean[cmds.size()];
                    starter.masks(masks);
                } else {
                    starter.masks(this.prefix(masks));
                }
            }
            return this.decorated.launch(starter);
        }

        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            return this.decorated.launchChannel(this.prefix(cmd), out, workDir, envVars);
        }

        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.decorated.kill(modelEnvVars);
        }

        private String[] prefix(String[] args) {
            String[] newArgs = new String[args.length + this.prefix.length];
            System.arraycopy(this.prefix, 0, newArgs, 0, this.prefix.length);
            System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
            return newArgs;
        }

        private boolean[] prefix(boolean[] args) {
            boolean[] newArgs = new boolean[args.length + this.prefix.length];
            System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
            return newArgs;
        }
    }
}

