/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.PermalinkProjectAction;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SpecificBuildSelector
extends BuildSelector {
    private static final Logger LOGGER = Logger.getLogger(SpecificBuildSelector.class.getName());
    private final String buildNumber;
    @Deprecated
    public static Descriptor<BuildSelector> DESCRIPTOR;

    @DataBoundConstructor
    public SpecificBuildSelector(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        String num = env.expand(this.buildNumber);
        if (num.startsWith("$")) {
            LOGGER.log(Level.FINE, "unresolved variable {0}", num);
            return null;
        }
        Run run = null;
        if (num.matches("[0-9]*")) {
            run = job.getBuildByNumber(Integer.parseInt(num));
        } else {
            PermalinkProjectAction.Permalink p = job.getPermalinks().get(num);
            if (p == null) {
                for (Run build : job.getBuilds()) {
                    if (!num.equals(build.getDisplayName())) continue;
                    run = build;
                    break;
                }
            } else {
                run = p.resolve(job);
            }
        }
        if (run == null) {
            LOGGER.log(Level.FINE, "no such build {0} in {1}", new Object[]{num, job.getFullName()});
            return null;
        }
        if (!filter.isSelectable(run, env)) {
            LOGGER.log(Level.FINE, "{0} claims {1} is not selectable", new Object[]{filter, run});
            return null;
        }
        return run;
    }

    @Extension(ordinal=-10.0)
    @Symbol(value={"specific"})
    public static final class DescriptorImpl
    extends SimpleBuildSelectorDescriptor {
        public DescriptorImpl() {
            super(SpecificBuildSelector.class, Messages._SpecificBuildSelector_DisplayName());
            DESCRIPTOR = this;
        }
    }
}

