/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.PermalinkProjectAction;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.util.ComboBoxModel;
import java.util.Iterator;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PermalinkBuildSelector
extends BuildSelector {
    public final String id;

    @DataBoundConstructor
    public PermalinkBuildSelector(String id) {
        this.id = id;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        PermalinkProjectAction.Permalink p = job.getPermalinks().get(this.id);
        if (p == null) {
            return null;
        }
        Run run = p.resolve(job);
        return run != null && filter.isSelectable(run, env) ? run : null;
    }

    @Extension
    @Symbol(value={"permalink"})
    public static class DescriptorImpl
    extends Descriptor<BuildSelector> {
        public String getDisplayName() {
            return Messages.PermalinkBuildSelector_DisplayName();
        }

        public ComboBoxModel doFillIdItems(@AncestorInPath Job copyingJob, @RelativePath(value="..") @QueryParameter(value="projectName") String projectName) {
            Job j = null;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (projectName != null && jenkins != null) {
                j = (Job)jenkins.getItem(projectName, (Item)copyingJob, Job.class);
            }
            ComboBoxModel r = new ComboBoxModel();
            Iterator iterator = (j != null ? j.getPermalinks() : PermalinkProjectAction.Permalink.BUILTIN).iterator();
            while (iterator.hasNext()) {
                PermalinkProjectAction.Permalink p = (PermalinkProjectAction.Permalink)iterator.next();
                r.add((Object)p.getId());
            }
            return r;
        }
    }
}

