// CHECKSTYLE:OFF

package com.robestone.hudson.compactcolumns;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static String startedAgo(Object arg0) {
        return holder.format("startedAgo", arg0);
    }

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static Localizable _startedAgo(Object arg0) {
        return new Localizable(holder, "startedAgo", arg0);
    }

    /**
     * Key {@code util.year}: {@code {0} yr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} yr}
     */
    public static String util_year(Object arg0) {
        return holder.format("util.year", arg0);
    }

    /**
     * Key {@code util.year}: {@code {0} yr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} yr}
     */
    public static Localizable _util_year(Object arg0) {
        return new Localizable(holder, "util.year", arg0);
    }

    /**
     * Key {@code util.day}: {@code {0} {0,choice,0#days|1#day|1<days}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#days|1#day|1<days}}
     */
    public static String util_day(Object arg0) {
        return holder.format("util.day", arg0);
    }

    /**
     * Key {@code util.day}: {@code {0} {0,choice,0#days|1#day|1<days}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,0#days|1#day|1<days}}
     */
    public static Localizable _util_day(Object arg0) {
        return new Localizable(holder, "util.day", arg0);
    }

    /**
     * Key {@code ballColor.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static String ballColor_Aborted() {
        return holder.format("ballColor.Aborted");
    }

    /**
     * Key {@code ballColor.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static Localizable _ballColor_Aborted() {
        return new Localizable(holder, "ballColor.Aborted");
    }

    /**
     * Key {@code run.summary.stable}: {@code stable}.
     * 
     * @return
     *     {@code stable}
     */
    public static String run_summary_stable() {
        return holder.format("run.summary.stable");
    }

    /**
     * Key {@code run.summary.stable}: {@code stable}.
     * 
     * @return
     *     {@code stable}
     */
    public static Localizable _run_summary_stable() {
        return new Localizable(holder, "run.summary.stable");
    }

    /**
     * Key {@code Compact_Column_Job_Name_w_Options}: {@code Compact Column:
     * Job Name w/ Options}.
     * 
     * @return
     *     {@code Compact Column: Job Name w/ Options}
     */
    public static String Compact_Column_Job_Name_w_Options() {
        return holder.format("Compact_Column_Job_Name_w_Options");
    }

    /**
     * Key {@code Compact_Column_Job_Name_w_Options}: {@code Compact Column:
     * Job Name w/ Options}.
     * 
     * @return
     *     {@code Compact Column: Job Name w/ Options}
     */
    public static Localizable _Compact_Column_Job_Name_w_Options() {
        return new Localizable(holder, "Compact_Column_Job_Name_w_Options");
    }

    /**
     * Key {@code ballColor.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static String ballColor_Failed() {
        return holder.format("ballColor.Failed");
    }

    /**
     * Key {@code ballColor.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static Localizable _ballColor_Failed() {
        return new Localizable(holder, "ballColor.Failed");
    }

    /**
     * Key {@code jobColumn.displayName}: {@code Name}.
     * 
     * @return
     *     {@code Name}
     */
    public static String jobColumn_displayName() {
        return holder.format("jobColumn.displayName");
    }

    /**
     * Key {@code jobColumn.displayName}: {@code Name}.
     * 
     * @return
     *     {@code Name}
     */
    public static Localizable _jobColumn_displayName() {
        return new Localizable(holder, "jobColumn.displayName");
    }

    /**
     * Key {@code buildNumber}: {@code Build #}.
     * 
     * @return
     *     {@code Build #}
     */
    public static String buildNumber() {
        return holder.format("buildNumber");
    }

    /**
     * Key {@code buildNumber}: {@code Build #}.
     * 
     * @return
     *     {@code Build #}
     */
    public static Localizable _buildNumber() {
        return new Localizable(holder, "buildNumber");
    }

    /**
     * Key {@code Compact_Column_Statuses_w_Options}: {@code Compact Column:
     * Statuses w/ Options}.
     * 
     * @return
     *     {@code Compact Column: Statuses w/ Options}
     */
    public static String Compact_Column_Statuses_w_Options() {
        return holder.format("Compact_Column_Statuses_w_Options");
    }

    /**
     * Key {@code Compact_Column_Statuses_w_Options}: {@code Compact Column:
     * Statuses w/ Options}.
     * 
     * @return
     *     {@code Compact Column: Statuses w/ Options}
     */
    public static Localizable _Compact_Column_Statuses_w_Options() {
        return new Localizable(holder, "Compact_Column_Statuses_w_Options");
    }

    /**
     * Key {@code lastedDuration}: {@code Lasted <b>{0}</b>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Lasted <b>{0}</b>}
     */
    public static String lastedDuration(Object arg0) {
        return holder.format("lastedDuration", arg0);
    }

    /**
     * Key {@code lastedDuration}: {@code Lasted <b>{0}</b>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Lasted <b>{0}</b>}
     */
    public static Localizable _lastedDuration(Object arg0) {
        return new Localizable(holder, "lastedDuration", arg0);
    }

    /**
     * Key {@code util.hour}: {@code {0} hr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} hr}
     */
    public static String util_hour(Object arg0) {
        return holder.format("util.hour", arg0);
    }

    /**
     * Key {@code util.hour}: {@code {0} hr}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} hr}
     */
    public static Localizable _util_hour(Object arg0) {
        return new Localizable(holder, "util.hour", arg0);
    }

    /**
     * Key {@code Compact_Column_Job_Name_w_Status_Color}: {@code Compact
     * Column: Job Name w/ Status Color}.
     * 
     * @return
     *     {@code Compact Column: Job Name w/ Status Color}
     */
    public static String Compact_Column_Job_Name_w_Status_Color() {
        return holder.format("Compact_Column_Job_Name_w_Status_Color");
    }

    /**
     * Key {@code Compact_Column_Job_Name_w_Status_Color}: {@code Compact
     * Column: Job Name w/ Status Color}.
     * 
     * @return
     *     {@code Compact Column: Job Name w/ Status Color}
     */
    public static Localizable _Compact_Column_Job_Name_w_Status_Color() {
        return new Localizable(holder, "Compact_Column_Job_Name_w_Status_Color");
    }

    /**
     * Key {@code Compact_Column_Stable_Failed}: {@code Compact Column:
     * Stable + Failed}.
     * 
     * @return
     *     {@code Compact Column: Stable + Failed}
     */
    public static String Compact_Column_Stable_Failed() {
        return holder.format("Compact_Column_Stable_Failed");
    }

    /**
     * Key {@code Compact_Column_Stable_Failed}: {@code Compact Column:
     * Stable + Failed}.
     * 
     * @return
     *     {@code Compact Column: Stable + Failed}
     */
    public static Localizable _Compact_Column_Stable_Failed() {
        return new Localizable(holder, "Compact_Column_Stable_Failed");
    }

    /**
     * Key {@code builtAt}: {@code Built @ <b>{0}</b>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Built @ <b>{0}</b>}
     */
    public static String builtAt(Object arg0) {
        return holder.format("builtAt", arg0);
    }

    /**
     * Key {@code builtAt}: {@code Built @ <b>{0}</b>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Built @ <b>{0}</b>}
     */
    public static Localizable _builtAt(Object arg0) {
        return new Localizable(holder, "builtAt", arg0);
    }

    /**
     * Key {@code util.month}: {@code {0} mo}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} mo}
     */
    public static String util_month(Object arg0) {
        return holder.format("util.month", arg0);
    }

    /**
     * Key {@code util.month}: {@code {0} mo}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} mo}
     */
    public static Localizable _util_month(Object arg0) {
        return new Localizable(holder, "util.month", arg0);
    }

    /**
     * Key {@code util.second}: {@code {0} sec}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} sec}
     */
    public static String util_second(Object arg0) {
        return holder.format("util.second", arg0);
    }

    /**
     * Key {@code util.second}: {@code {0} sec}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} sec}
     */
    public static Localizable _util_second(Object arg0) {
        return new Localizable(holder, "util.second", arg0);
    }

    /**
     * Key {@code util.minute}: {@code {0} min}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} min}
     */
    public static String util_minute(Object arg0) {
        return holder.format("util.minute", arg0);
    }

    /**
     * Key {@code util.minute}: {@code {0} min}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} min}
     */
    public static Localizable _util_minute(Object arg0) {
        return new Localizable(holder, "util.minute", arg0);
    }

    /**
     * Key {@code latestBuild}: {@code Latest Build}.
     * 
     * @return
     *     {@code Latest Build}
     */
    public static String latestBuild() {
        return holder.format("latestBuild");
    }

    /**
     * Key {@code latestBuild}: {@code Latest Build}.
     * 
     * @return
     *     {@code Latest Build}
     */
    public static Localizable _latestBuild() {
        return new Localizable(holder, "latestBuild");
    }

    /**
     * Key {@code Compact_Column_Unstable_Stable}: {@code Compact Column:
     * Unstable + Stable}.
     * 
     * @return
     *     {@code Compact Column: Unstable + Stable}
     */
    public static String Compact_Column_Unstable_Stable() {
        return holder.format("Compact_Column_Unstable_Stable");
    }

    /**
     * Key {@code Compact_Column_Unstable_Stable}: {@code Compact Column:
     * Unstable + Stable}.
     * 
     * @return
     *     {@code Compact Column: Unstable + Stable}
     */
    public static Localizable _Compact_Column_Unstable_Stable() {
        return new Localizable(holder, "Compact_Column_Unstable_Stable");
    }

    /**
     * Key {@code ballColor.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static String ballColor_Unstable() {
        return holder.format("ballColor.Unstable");
    }

    /**
     * Key {@code ballColor.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static Localizable _ballColor_Unstable() {
        return new Localizable(holder, "ballColor.Unstable");
    }

    /**
     * Key {@code Compact_Column_Job_Name}: {@code Compact Column: Job Name}.
     * 
     * @return
     *     {@code Compact Column: Job Name}
     */
    public static String Compact_Column_Job_Name() {
        return holder.format("Compact_Column_Job_Name");
    }

    /**
     * Key {@code Compact_Column_Job_Name}: {@code Compact Column: Job Name}.
     * 
     * @return
     *     {@code Compact Column: Job Name}
     */
    public static Localizable _Compact_Column_Job_Name() {
        return new Localizable(holder, "Compact_Column_Job_Name");
    }

}
