/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene.Domain;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class ReviewOfNewFile {
    private final String name;
    private final List<String> reviewResults;

    public ReviewOfNewFile(JsonObject newFileWarning) {
        if (null == newFileWarning) {
            throw new IllegalArgumentException("The new file warning cannot be null. This should be checked in the calling context");
        }
        this.name = newFileWarning.getString("name", "Missing Name");
        this.reviewResults = this.parseReviewResultsFrom(newFileWarning);
    }

    private List<String> parseReviewResultsFrom(JsonObject w) {
        ArrayList<String> reviewResults = new ArrayList<String>();
        JsonArray reviews = w.getJsonArray("review");
        if (null != reviews) {
            for (int i = 0; i < reviews.size(); ++i) {
                JsonObject r = reviews.getJsonObject(i);
                reviewResults.add(r.getString("title") + ": " + this.parseDescription((JsonValue)r.get((Object)"description")));
            }
        }
        return reviewResults;
    }

    private String parseDescription(JsonValue description) {
        StringBuilder sb = new StringBuilder();
        if (description != null) {
            switch (description.getValueType()) {
                case ARRAY: {
                    JsonArray array = (JsonArray)description;
                    for (int i = 0; i < array.size(); ++i) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(array.getString(i));
                    }
                    break;
                }
                case STRING: {
                    sb.append(description);
                    break;
                }
            }
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getReviewResults() {
        return this.reviewResults;
    }
}

