/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codescene.Domain;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jenkinsci.plugins.codescene.Domain.Configuration;

public class QualityGates {
    private boolean goalHasFailed;
    private boolean codeHealthDeclined;
    private boolean gatesEnabled;
    private String codeOwners;

    public QualityGates(JsonObject deltaResult, Configuration userConfig) {
        JsonObject gatesField = deltaResult.getJsonObject("quality-gates");
        if (null == gatesField) {
            throw new IllegalArgumentException("The quality gates field cannot be null. This should be checked in the calling context");
        }
        this.goalHasFailed = userConfig.failOnFailedGoal() && gatesField.getBoolean("violates-goal");
        this.codeHealthDeclined = userConfig.failOnDecliningCodeHealth() && gatesField.getBoolean("degrades-in-code-health");
        this.gatesEnabled = userConfig.failOnFailedGoal() || userConfig.failOnDecliningCodeHealth();
        this.codeOwners = this.parseOptionalOwnersFrom(deltaResult);
    }

    private String parseOptionalOwnersFrom(JsonObject deltaResult) {
        if (!deltaResult.containsKey((Object)"code-owners-for-quality-gates")) {
            return "-";
        }
        JsonArray owners = deltaResult.getJsonArray("code-owners-for-quality-gates");
        StringBuilder formattedOwners = new StringBuilder();
        String separator = "";
        for (int i = 0; i < owners.size(); ++i) {
            formattedOwners.append(separator);
            formattedOwners.append(owners.getString(i));
            separator = ", ";
        }
        return formattedOwners.toString();
    }

    private QualityGates(boolean enableFailedGoalGate, boolean enableCodeHealthGate) {
        this.goalHasFailed = enableFailedGoalGate;
        this.codeHealthDeclined = enableCodeHealthGate;
        this.codeOwners = "-";
    }

    public static QualityGates none() {
        return new QualityGates(false, false);
    }

    public boolean goalHasFailed() {
        return this.goalHasFailed;
    }

    public boolean codeHealthDeclined() {
        return this.codeHealthDeclined;
    }

    public boolean enabled() {
        return this.gatesEnabled;
    }

    public String codeOwners() {
        return this.codeOwners;
    }

    public boolean hasCodeOwners() {
        return !this.codeOwners.isEmpty() && !this.codeOwners.equals("-");
    }
}

